/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.impl.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryOperator;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.UnaryOperator;
import it.unive.lisa.symbolic.value.ValueExpression;

public class Parity
extends BaseNonRelationalValueDomain<Parity> {
    private static final Parity EVEN = new Parity(3);
    private static final Parity ODD = new Parity(2);
    private static final Parity TOP = new Parity(0);
    private static final Parity BOTTOM = new Parity(1);
    private final byte parity;

    public Parity() {
        this(0);
    }

    private Parity(byte parity) {
        this.parity = parity;
    }

    @Override
    public Parity top() {
        return TOP;
    }

    @Override
    public Parity bottom() {
        return BOTTOM;
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        String repr = this == EVEN ? "Even" : "Odd";
        return new StringRepresentation(repr);
    }

    @Override
    protected Parity evalNullConstant(ProgramPoint pp) {
        return this.top();
    }

    @Override
    protected Parity evalNonNullConstant(Constant constant, ProgramPoint pp) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return i % 2 == 0 ? EVEN : ODD;
        }
        return this.top();
    }

    private boolean isEven() {
        return this == EVEN;
    }

    private boolean isOdd() {
        return this == ODD;
    }

    @Override
    protected Parity evalUnaryExpression(UnaryOperator operator, Parity arg, ProgramPoint pp) {
        switch (operator) {
            case NUMERIC_NEG: {
                return arg;
            }
        }
        return this.top();
    }

    @Override
    protected Parity evalBinaryExpression(BinaryOperator operator, Parity left, Parity right, ProgramPoint pp) {
        if (left.isTop() || right.isTop()) {
            return this.top();
        }
        switch (operator) {
            case NUMERIC_ADD: 
            case NUMERIC_SUB: {
                if (right.equals(left)) {
                    return EVEN;
                }
                return ODD;
            }
            case NUMERIC_MUL: {
                if (left.isEven() || right.isEven()) {
                    return EVEN;
                }
                return ODD;
            }
            case NUMERIC_DIV: {
                if (left.isOdd()) {
                    return right.isOdd() ? ODD : EVEN;
                }
                return right.isOdd() ? EVEN : TOP;
            }
            case NUMERIC_MOD: {
                return TOP;
            }
        }
        return TOP;
    }

    @Override
    protected Parity lubAux(Parity other) throws SemanticException {
        return TOP;
    }

    @Override
    protected Parity wideningAux(Parity other) throws SemanticException {
        return this.lubAux(other);
    }

    @Override
    protected boolean lessOrEqualAux(Parity other) throws SemanticException {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.parity;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parity other = (Parity)obj;
        return this.parity == other.parity;
    }

    @Override
    protected ValueEnvironment<Parity> assumeBinaryExpression(ValueEnvironment<Parity> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint pp) throws SemanticException {
        switch (operator) {
            case COMPARISON_EQ: {
                if (left instanceof Identifier) {
                    environment = (ValueEnvironment)environment.assign((Identifier)left, right, pp);
                } else if (right instanceof Identifier) {
                    environment = (ValueEnvironment)environment.assign((Identifier)right, left, pp);
                }
                return environment;
            }
        }
        return environment;
    }
}

