/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.impl.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryOperator;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.TernaryOperator;
import it.unive.lisa.symbolic.value.UnaryOperator;
import it.unive.lisa.symbolic.value.ValueExpression;

public class Sign
extends BaseNonRelationalValueDomain<Sign> {
    private static final Sign POS = new Sign(4);
    private static final Sign NEG = new Sign(3);
    private static final Sign ZERO = new Sign(2);
    private static final Sign TOP = new Sign(0);
    private static final Sign BOTTOM = new Sign(1);
    private final byte sign;

    public Sign() {
        this(0);
    }

    private Sign(byte sign) {
        this.sign = sign;
    }

    @Override
    public Sign top() {
        return TOP;
    }

    @Override
    public Sign bottom() {
        return BOTTOM;
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        String repr = this == ZERO ? "0" : (this == POS ? "+" : "-");
        return new StringRepresentation(repr);
    }

    @Override
    protected Sign evalNullConstant(ProgramPoint pp) {
        return this.top();
    }

    @Override
    protected Sign evalNonNullConstant(Constant constant, ProgramPoint pp) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return i == 0 ? ZERO : (i > 0 ? POS : NEG);
        }
        return this.top();
    }

    private boolean isPositive() {
        return this == POS;
    }

    private boolean isZero() {
        return this == ZERO;
    }

    private boolean isNegative() {
        return this == NEG;
    }

    private Sign opposite() {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        return this.isPositive() ? NEG : (this.isNegative() ? POS : ZERO);
    }

    @Override
    protected Sign evalUnaryExpression(UnaryOperator operator, Sign arg, ProgramPoint pp) {
        switch (operator) {
            case NUMERIC_NEG: {
                if (arg.isPositive()) {
                    return NEG;
                }
                if (arg.isNegative()) {
                    return POS;
                }
                if (arg.isZero()) {
                    return ZERO;
                }
                return TOP;
            }
        }
        return TOP;
    }

    @Override
    protected Sign evalBinaryExpression(BinaryOperator operator, Sign left, Sign right, ProgramPoint pp) {
        switch (operator) {
            case NUMERIC_ADD: {
                if (left.isZero()) {
                    return right;
                }
                if (right.isZero()) {
                    return left;
                }
                if (left.equals(right)) {
                    return left;
                }
                return this.top();
            }
            case NUMERIC_SUB: {
                if (left.isZero()) {
                    return right.opposite();
                }
                if (right.isZero()) {
                    return left.opposite();
                }
                if (left.equals(right)) {
                    return this.top();
                }
                return left;
            }
            case NUMERIC_DIV: {
                if (right.isZero()) {
                    return this.bottom();
                }
                if (left.isZero()) {
                    return ZERO;
                }
                if (left.equals(right)) {
                    return left.isTop() ? left : POS;
                }
                return this.top();
            }
            case NUMERIC_MOD: {
                return this.top();
            }
            case NUMERIC_MUL: {
                if (left.isZero() || right.isZero()) {
                    return ZERO;
                }
                if (left.equals(right)) {
                    return POS;
                }
                return NEG;
            }
        }
        return TOP;
    }

    @Override
    protected Sign lubAux(Sign other) throws SemanticException {
        return TOP;
    }

    @Override
    protected Sign wideningAux(Sign other) throws SemanticException {
        return this.lubAux(other);
    }

    @Override
    protected boolean lessOrEqualAux(Sign other) throws SemanticException {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.sign;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sign other = (Sign)obj;
        return this.sign == other.sign;
    }

    @Override
    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, Sign left, Sign right, ProgramPoint pp) {
        if (left.isTop() || right.isTop()) {
            return SemanticDomain.Satisfiability.UNKNOWN;
        }
        switch (operator) {
            case COMPARISON_EQ: {
                return left.eq(right);
            }
            case COMPARISON_GE: {
                return left.eq(right).or(left.gt(right));
            }
            case COMPARISON_GT: {
                return left.gt(right);
            }
            case COMPARISON_LE: {
                return left.gt(right).negate();
            }
            case COMPARISON_LT: {
                return left.gt(right).negate().and(left.eq(right).negate());
            }
            case COMPARISON_NE: {
                return left.eq(right).negate();
            }
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    private SemanticDomain.Satisfiability eq(Sign other) {
        if (!this.equals(other)) {
            return SemanticDomain.Satisfiability.NOT_SATISFIED;
        }
        if (this.isZero()) {
            return SemanticDomain.Satisfiability.SATISFIED;
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    private SemanticDomain.Satisfiability gt(Sign other) {
        if (this.equals(other)) {
            return this.isZero() ? SemanticDomain.Satisfiability.NOT_SATISFIED : SemanticDomain.Satisfiability.UNKNOWN;
        }
        if (this.isZero()) {
            return other.isPositive() ? SemanticDomain.Satisfiability.NOT_SATISFIED : SemanticDomain.Satisfiability.SATISFIED;
        }
        if (this.isPositive()) {
            return SemanticDomain.Satisfiability.SATISFIED;
        }
        return SemanticDomain.Satisfiability.NOT_SATISFIED;
    }

    @Override
    protected SemanticDomain.Satisfiability satisfiesTernaryExpression(TernaryOperator operator, Sign left, Sign middle, Sign right, ProgramPoint pp) {
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    @Override
    protected ValueEnvironment<Sign> assumeBinaryExpression(ValueEnvironment<Sign> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint pp) throws SemanticException {
        switch (operator) {
            case COMPARISON_EQ: {
                if (left instanceof Identifier) {
                    environment = (ValueEnvironment)environment.assign((Identifier)left, right, pp);
                } else if (right instanceof Identifier) {
                    environment = (ValueEnvironment)environment.assign((Identifier)right, left, pp);
                }
                return environment;
            }
            case COMPARISON_GE: {
                Sign leftSign;
                if (left instanceof Identifier) {
                    Sign rightSign = this.eval(right, environment, pp);
                    if (rightSign.isPositive()) {
                        environment = (ValueEnvironment)environment.assign((Identifier)left, right, pp);
                    }
                } else if (right instanceof Identifier && (leftSign = (Sign)this.eval(left, environment, pp)).isNegative()) {
                    environment = (ValueEnvironment)environment.assign((Identifier)right, left, pp);
                }
                return environment;
            }
            case COMPARISON_LE: {
                Sign leftSign;
                if (left instanceof Identifier) {
                    Sign rightSign = this.eval(right, environment, pp);
                    if (rightSign.isNegative()) {
                        environment = (ValueEnvironment)environment.assign((Identifier)left, right, pp);
                    }
                } else if (right instanceof Identifier && (leftSign = (Sign)this.eval(left, environment, pp)).isPositive()) {
                    environment = (ValueEnvironment)environment.assign((Identifier)right, left, pp);
                }
                return environment;
            }
            case COMPARISON_LT: {
                Sign leftSign;
                if (left instanceof Identifier) {
                    Sign rightSign = this.eval(right, environment, pp);
                    if (rightSign.isNegative() || rightSign.isZero()) {
                        environment = (ValueEnvironment)environment.assign((Identifier)left, new Constant(right.getDynamicType(), -1, right.getCodeLocation()), pp);
                    }
                } else if (right instanceof Identifier && ((leftSign = (Sign)this.eval(left, environment, pp)).isPositive() || leftSign.isZero())) {
                    environment = (ValueEnvironment)environment.assign((Identifier)right, new Constant(left.getDynamicType(), 1, left.getCodeLocation()), pp);
                }
                return environment;
            }
            case COMPARISON_GT: {
                Sign leftSign;
                if (left instanceof Identifier) {
                    Sign rightSign = this.eval(right, environment, pp);
                    if (rightSign.isPositive() || rightSign.isZero()) {
                        environment = (ValueEnvironment)environment.assign((Identifier)left, new Constant(right.getDynamicType(), 1, right.getCodeLocation()), pp);
                    }
                } else if (right instanceof Identifier && ((leftSign = (Sign)this.eval(left, environment, pp)).isNegative() || leftSign.isZero())) {
                    environment = (ValueEnvironment)environment.assign((Identifier)right, new Constant(left.getDynamicType(), -1, right.getCodeLocation()), pp);
                }
                return environment;
            }
        }
        return environment;
    }
}

