/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.lattices;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticExceptionWrapper;
import it.unive.lisa.analysis.lattices.SetLattice;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.util.collections.CollectionUtilities;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExpressionSet<T extends SymbolicExpression>
extends SetLattice<ExpressionSet<T>, T> {
    private final boolean isTop;

    public ExpressionSet() {
        this(Collections.emptySet(), false);
    }

    public ExpressionSet(T exp) {
        this(Collections.singleton(exp), false);
    }

    public ExpressionSet(Set<T> set) {
        this(set, false);
    }

    private ExpressionSet(boolean isTop) {
        this(Collections.emptySet(), isTop);
    }

    private ExpressionSet(Set<T> set, boolean isTop) {
        super(set);
        this.isTop = isTop;
    }

    @Override
    public boolean isTop() {
        return this.isTop;
    }

    @Override
    public ExpressionSet<T> top() {
        return new ExpressionSet<T>(true);
    }

    @Override
    public boolean isBottom() {
        return !this.isTop && this.elements.isEmpty();
    }

    @Override
    public ExpressionSet<T> bottom() {
        return new ExpressionSet<T>();
    }

    @Override
    protected ExpressionSet<T> mk(Set<T> set) {
        return new ExpressionSet<T>(set);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isTop ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionSet other = (ExpressionSet)obj;
        return this.isTop == other.isTop;
    }

    @Override
    protected ExpressionSet<T> lubAux(ExpressionSet<T> other) throws SemanticException {
        HashSet lub = new HashSet();
        this.elements.stream().filter(Predicate.not(Identifier.class::isInstance)).forEach(lub::add);
        other.elements.stream().filter(Predicate.not(Identifier.class::isInstance)).forEach(lub::add);
        HashSet idlub = new HashSet();
        CollectionUtilities.join(this.onlyIds(), other.onlyIds(), idlub, (id1, id2) -> id1.getName().equals(id2.getName()), ExpressionSet::wrapper);
        idlub.stream().map(i -> i).forEach(lub::add);
        return new ExpressionSet(lub);
    }

    private static Identifier wrapper(Identifier id1, Identifier id2) {
        try {
            return id1.lub(id2);
        }
        catch (SemanticException e) {
            throw new SemanticExceptionWrapper(e);
        }
    }

    private Collection<Identifier> onlyIds() {
        return this.elements.stream().filter(Identifier.class::isInstance).map(Identifier.class::cast).collect(Collectors.toSet());
    }
}

