/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.lattices;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class FunctionalLattice<F extends FunctionalLattice<F, K, V>, K, V extends Lattice<V>>
extends BaseLattice<F>
implements Iterable<Map.Entry<K, V>> {
    protected Map<K, V> function;
    public final V lattice;

    protected FunctionalLattice(V lattice) {
        this.lattice = lattice;
        this.function = this.mkNewFunction(null);
    }

    protected FunctionalLattice(V lattice, Map<K, V> function) {
        this.lattice = lattice;
        this.function = function;
    }

    protected Map<K, V> mkNewFunction(Map<K, V> other) {
        if (other == null) {
            return new HashMap();
        }
        return new HashMap<K, V>(other);
    }

    public final Set<K> getKeys() {
        if (this.function == null) {
            return Collections.emptySet();
        }
        return this.function.keySet();
    }

    public final V getState(K key) {
        if (this.isBottom()) {
            return (V)this.lattice.bottom();
        }
        if (this.isTop()) {
            return (V)this.lattice.top();
        }
        if (this.function.containsKey(key)) {
            return (V)((Lattice)this.function.get(key));
        }
        return (V)this.lattice.bottom();
    }

    public final F putState(K key, V state) {
        F result = this.mk(this.lattice, this.mkNewFunction(null));
        ((FunctionalLattice)result).function.put(key, state);
        for (K k : this.getKeys()) {
            if (k.equals(key)) continue;
            ((FunctionalLattice)result).function.put(k, this.getState(k));
        }
        return result;
    }

    protected abstract F mk(V var1, Map<K, V> var2);

    @Override
    public F lubAux(F other) throws SemanticException {
        return this.functionalLift(other, this::lubKeys, (o1, o2) -> o1 == null ? o2 : o1.lub(o2));
    }

    @Override
    public F wideningAux(F other) throws SemanticException {
        return this.functionalLift(other, this::lubKeys, (o1, o2) -> o1 == null ? o2 : o1.widening(o2));
    }

    protected final F functionalLift(F other, KeyFunctionalLift<K> keyLifter, FunctionalLift<V> valueLifter) throws SemanticException {
        F result = this.mk(this.lattice.lub(((FunctionalLattice)other).lattice), this.mkNewFunction(null));
        Set<K> keys = keyLifter.keyLift(this.getKeys(), ((FunctionalLattice)other).getKeys());
        for (K key : keys) {
            try {
                ((FunctionalLattice)result).function.put(key, valueLifter.lift(this.getState(key), ((FunctionalLattice)other).getState(key)));
            }
            catch (SemanticException e) {
                throw new SemanticException("Exception during functional lifting of key '" + key + "'", e);
            }
        }
        return result;
    }

    protected Set<K> lubKeys(Set<K> k1, Set<K> k2) throws SemanticException {
        HashSet<K> keys = new HashSet<K>(k1);
        keys.addAll(k2);
        return keys;
    }

    protected Set<K> glbKeys(Set<K> k1, Set<K> k2) throws SemanticException {
        HashSet<K> keys = new HashSet<K>(k1);
        keys.retainAll(k2);
        return keys;
    }

    @Override
    public boolean lessOrEqualAux(F other) throws SemanticException {
        for (K key : this.function.keySet()) {
            if (this.getState(key) == null || this.getState(key).lessOrEqual(((FunctionalLattice)other).getState(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.lattice == null ? 0 : this.lattice.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionalLattice other = (FunctionalLattice)obj;
        if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
            return false;
        }
        return !(this.lattice == null ? other.lattice != null : !this.lattice.equals(other.lattice));
    }

    @Override
    public String toString() {
        if (this.isTop()) {
            return "#TOP#";
        }
        if (this.isBottom()) {
            return "_|_";
        }
        return this.function.toString();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        if (this.function == null) {
            return Collections.emptyIterator();
        }
        return this.function.entrySet().iterator();
    }

    public Collection<V> getValues() {
        if (this.function == null) {
            return Collections.emptySet();
        }
        return this.function.values();
    }

    public Map<K, V> getMap() {
        return this.function;
    }

    @FunctionalInterface
    protected static interface KeyFunctionalLift<K> {
        public Set<K> keyLift(Set<K> var1, Set<K> var2) throws SemanticException;
    }

    @FunctionalInterface
    protected static interface FunctionalLift<V extends Lattice<V>> {
        public V lift(V var1, V var2) throws SemanticException;
    }
}

