/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.lattices;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class SetLattice<S extends SetLattice<S, E>, E>
extends BaseLattice<S>
implements Iterable<E> {
    protected Set<E> elements;

    protected SetLattice(Set<E> elements) {
        this.elements = elements;
    }

    protected abstract S mk(Set<E> var1);

    @Override
    protected S lubAux(S other) throws SemanticException {
        HashSet<E> lub = new HashSet<E>(this.elements);
        lub.addAll(((SetLattice)other).elements);
        return this.mk(lub);
    }

    public final S glb(S other) throws SemanticException {
        if (other == null || this.isBottom() || other.isTop() || this == other || this.equals(other) || this.lessOrEqual(other)) {
            return (S)this;
        }
        if (other.isBottom() || this.isTop() || ((BaseLattice)other).lessOrEqual((SetLattice)this)) {
            return other;
        }
        HashSet<E> glb = new HashSet<E>(this.elements);
        glb.retainAll(((SetLattice)other).elements);
        return this.mk(glb);
    }

    @Override
    protected S wideningAux(S other) throws SemanticException {
        return this.lubAux(other);
    }

    @Override
    protected boolean lessOrEqualAux(S other) throws SemanticException {
        return ((SetLattice)other).elements.containsAll(this.elements);
    }

    public boolean contains(E elem) {
        return this.elements.contains(elem);
    }

    public Set<E> elements() {
        return this.elements;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetLattice other = (SetLattice)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    @Override
    public final String toString() {
        if (this.isTop()) {
            return "#TOP#";
        }
        if (this.isBottom()) {
            return "_|_";
        }
        return this.elements.toString();
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }
}

