/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.inference;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.NonRelationalElement;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.PairRepresentation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.ValueExpression;

public interface InferredValue<T extends InferredValue<T>>
extends NonRelationalElement<T, ValueExpression, InferenceSystem<T>> {
    public InferredPair<T> eval(ValueExpression var1, InferenceSystem<T> var2, ProgramPoint var3) throws SemanticException;

    public static class InferredPairRepresentation
    extends PairRepresentation {
        public InferredPairRepresentation(InferredPair<?> pair) {
            super(pair.inferred.representation(), pair.state.representation());
        }

        @Override
        public String toString() {
            return "inferred: " + this.left + ", state: " + this.right;
        }
    }

    public static class InferredPair<T extends InferredValue<T>>
    extends BaseLattice<InferredPair<T>> {
        private final T domain;
        private final T inferred;
        private final T state;

        public InferredPair(T domain, T inferred, T state) {
            this.domain = domain;
            this.inferred = inferred;
            this.state = state;
        }

        public T getInferred() {
            return this.inferred;
        }

        public T getState() {
            return this.state;
        }

        @Override
        public InferredPair<T> top() {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.domain.top(), (InferredValue)this.domain.top());
        }

        @Override
        public boolean isTop() {
            return this.inferred.isTop() && this.state.isTop();
        }

        @Override
        public InferredPair<T> bottom() {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.domain.bottom(), (InferredValue)this.domain.bottom());
        }

        @Override
        public boolean isBottom() {
            return this.inferred.isBottom() && this.state.isBottom();
        }

        @Override
        protected InferredPair<T> lubAux(InferredPair<T> other) throws SemanticException {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.inferred.lub(other.inferred), (InferredValue)this.state.lub(other.state));
        }

        @Override
        protected InferredPair<T> wideningAux(InferredPair<T> other) throws SemanticException {
            return new InferredPair<InferredValue>((InferredValue)this.domain, (InferredValue)this.inferred.widening(other.inferred), (InferredValue)this.state.widening(other.state));
        }

        @Override
        protected boolean lessOrEqualAux(InferredPair<T> other) throws SemanticException {
            return this.inferred.lessOrEqual(other.inferred) && this.state.lessOrEqual(other.state);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
            result = 31 * result + (this.inferred == null ? 0 : this.inferred.hashCode());
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InferredPair other = (InferredPair)obj;
            if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
                return false;
            }
            if (this.inferred == null ? other.inferred != null : !this.inferred.equals(other.inferred)) {
                return false;
            }
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }

        @Override
        public String toString() {
            return this.representation().toString();
        }

        public DomainRepresentation representation() {
            return new InferredPairRepresentation(this);
        }
    }
}

