/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonrelational.value;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.Environment;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public final class ValueEnvironment<T extends NonRelationalValueDomain<T>>
extends Environment<ValueEnvironment<T>, ValueExpression, T, T>
implements ValueDomain<ValueEnvironment<T>> {
    public ValueEnvironment(T domain) {
        super(domain);
    }

    private ValueEnvironment(T domain, Map<Identifier, T> function) {
        super(domain, function);
    }

    @Override
    protected ValueEnvironment<T> mk(T lattice, Map<Identifier, T> function) {
        return new ValueEnvironment<T>(lattice, function);
    }

    @Override
    protected ValueEnvironment<T> copy() {
        return new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)this.lattice, this.mkNewFunction(this.function));
    }

    @Override
    protected Pair<T, T> eval(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        NonRelationalValueDomain eval = (NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).eval(expression, this, pp);
        return Pair.of((Object)eval, (Object)eval);
    }

    @Override
    protected ValueEnvironment<T> assignAux(Identifier id, ValueExpression expression, Map<Identifier, T> function, T value, T eval, ProgramPoint pp) {
        return new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)this.lattice, function);
    }

    @Override
    public ValueEnvironment<T> smallStepSemantics(ValueExpression expression, ProgramPoint pp) throws SemanticException {
        return this;
    }

    @Override
    protected ValueEnvironment<T> assumeSatisfied(T eval) {
        return this;
    }

    @Override
    protected ValueEnvironment<T> glbAux(T lattice, Map<Identifier, T> function, ValueEnvironment<T> other) {
        return new ValueEnvironment<T>(lattice, function);
    }

    @Override
    public ValueEnvironment<T> top() {
        return this.isTop() ? this : new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).top(), (Map<Identifier, NonRelationalValueDomain>)null);
    }

    @Override
    public ValueEnvironment<T> bottom() {
        return this.isBottom() ? this : new ValueEnvironment<NonRelationalValueDomain>((NonRelationalValueDomain)((NonRelationalValueDomain)this.lattice).bottom(), (Map<Identifier, NonRelationalValueDomain>)null);
    }
}

