/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.representation;

import it.unive.lisa.analysis.representation.DomainRepresentation;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;

public class MapRepresentation
extends DomainRepresentation {
    private final SortedMap<DomainRepresentation, DomainRepresentation> map;

    public <K, V> MapRepresentation(Map<K, V> map, Function<K, DomainRepresentation> keyMapper, Function<V, DomainRepresentation> valueMapper) {
        this.map = new TreeMap<DomainRepresentation, DomainRepresentation>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.map.put(keyMapper.apply(e.getKey()), valueMapper.apply(e.getValue()));
        }
    }

    public MapRepresentation(Map<DomainRepresentation, DomainRepresentation> map) {
        this.map = map instanceof SortedMap ? (SortedMap<Object, Object>)map : new TreeMap<DomainRepresentation, DomainRepresentation>(map);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<DomainRepresentation, DomainRepresentation> e : this.map.entrySet()) {
            builder.append(e.getKey()).append(": ").append(e.getValue()).append("\n");
        }
        return builder.toString().trim();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapRepresentation other = (MapRepresentation)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }
}

