/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.representation;

import it.unive.lisa.analysis.representation.DomainRepresentation;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class SetRepresentation
extends DomainRepresentation {
    private final SortedSet<DomainRepresentation> elements;

    public <E> SetRepresentation(Set<E> elements, Function<E, DomainRepresentation> mapper) {
        this(SetRepresentation.mapAndSort(elements, mapper));
    }

    public SetRepresentation(Set<DomainRepresentation> elements) {
        this.elements = elements instanceof SortedSet ? (SortedSet<Object>)elements : new TreeSet<DomainRepresentation>(elements);
    }

    private static <E> SortedSet<DomainRepresentation> mapAndSort(Iterable<E> elements, Function<E, DomainRepresentation> mapper) {
        TreeSet<DomainRepresentation> result = new TreeSet<DomainRepresentation>();
        for (E e : elements) {
            result.add(mapper.apply(e));
        }
        return result;
    }

    @Override
    public String toString() {
        return "[" + StringUtils.join(this.elements, (String)", ") + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetRepresentation other = (SetRepresentation)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }
}

