/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.types;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.inference.BaseInferredValue;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.analysis.representation.DomainRepresentation;
import it.unive.lisa.analysis.representation.SetRepresentation;
import it.unive.lisa.analysis.representation.StringRepresentation;
import it.unive.lisa.caches.Caches;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.types.BoolType;
import it.unive.lisa.symbolic.types.IntType;
import it.unive.lisa.symbolic.types.StringType;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.BinaryOperator;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.TernaryOperator;
import it.unive.lisa.symbolic.value.UnaryOperator;
import it.unive.lisa.type.NullType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.TypeTokenType;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class InferredTypes
extends BaseInferredValue<InferredTypes> {
    private static final InferredTypes TOP = new InferredTypes(Caches.types().mkUniversalSet());
    private static final InferredTypes BOTTOM = new InferredTypes(Caches.types().mkEmptySet());
    private static final InferredValue.InferredPair<InferredTypes> BOTTOM_PAIR = new InferredValue.InferredPair<InferredTypes>(BOTTOM, BOTTOM, BOTTOM);
    private static final InferredValue.InferredPair<InferredTypes> TOP_PAIR = new InferredValue.InferredPair<InferredTypes>(TOP, TOP, TOP);
    private final ExternalSet<Type> elements;

    public InferredTypes() {
        this(Caches.types().mkEmptySet());
    }

    InferredTypes(Type type) {
        this(Caches.types().mkSingletonSet(type));
    }

    InferredTypes(ExternalSet<Type> types) {
        this.elements = types;
    }

    public ExternalSet<Type> getRuntimeTypes() {
        return this.elements;
    }

    @Override
    public InferredTypes top() {
        return TOP;
    }

    @Override
    public InferredTypes bottom() {
        return BOTTOM;
    }

    @Override
    public DomainRepresentation representation() {
        if (this.isTop()) {
            return Lattice.TOP_REPR;
        }
        if (this.isBottom()) {
            return Lattice.BOTTOM_REPR;
        }
        return new SetRepresentation(this.elements, StringRepresentation::new);
    }

    private InferredValue.InferredPair<InferredTypes> mk(InferredTypes types) {
        return new InferredValue.InferredPair<InferredTypes>(this, types, BOTTOM);
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalIdentifier(Identifier id, InferenceSystem<InferredTypes> environment, ProgramPoint pp) throws SemanticException {
        InferredValue.InferredPair<InferredTypes> eval = super.evalIdentifier(id, environment, pp);
        if (!eval.getInferred().isTop() && !eval.getInferred().isBottom()) {
            return eval;
        }
        return this.mk(new InferredTypes(id.getTypes()));
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalPushAny(PushAny pushAny, InferredTypes state, ProgramPoint pp) {
        return this.mk(new InferredTypes(pushAny.getTypes()));
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalNullConstant(InferredTypes state, ProgramPoint pp) {
        return this.mk(new InferredTypes(NullType.INSTANCE));
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalNonNullConstant(Constant constant, InferredTypes state, ProgramPoint pp) {
        return this.mk(new InferredTypes(constant.getDynamicType()));
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalUnaryExpression(UnaryOperator operator, InferredTypes arg, InferredTypes state, ProgramPoint pp) {
        switch (operator) {
            case LOGICAL_NOT: {
                if (arg.elements.noneMatch(Type::isBooleanType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(BoolType.INSTANCE));
            }
            case NUMERIC_NEG: {
                if (arg.elements.noneMatch(Type::isNumericType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(arg.elements.filter(Type::isNumericType)));
            }
            case STRING_LENGTH: {
                if (arg.elements.noneMatch(Type::isStringType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(IntType.INSTANCE));
            }
            case TYPEOF: {
                return this.mk(new InferredTypes(new TypeTokenType(arg.elements.copy())));
            }
        }
        return TOP_PAIR;
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalBinaryExpression(BinaryOperator operator, InferredTypes left, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        switch (operator) {
            case COMPARISON_EQ: 
            case COMPARISON_NE: {
                return this.mk(new InferredTypes(BoolType.INSTANCE));
            }
            case COMPARISON_GE: 
            case COMPARISON_GT: 
            case COMPARISON_LE: 
            case COMPARISON_LT: {
                if (left.elements.noneMatch(Type::isNumericType) || right.elements.noneMatch(Type::isNumericType)) {
                    return BOTTOM_PAIR;
                }
                ExternalSet<Type> set = this.commonNumericalType(left.elements, right.elements);
                if (set.isEmpty()) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(BoolType.INSTANCE));
            }
            case LOGICAL_AND: 
            case LOGICAL_OR: {
                if (left.elements.noneMatch(Type::isBooleanType) || right.elements.noneMatch(Type::isBooleanType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(BoolType.INSTANCE));
            }
            case NUMERIC_ADD: 
            case NUMERIC_DIV: 
            case NUMERIC_MOD: 
            case NUMERIC_MUL: 
            case NUMERIC_SUB: {
                if (left.elements.noneMatch(Type::isNumericType) || right.elements.noneMatch(Type::isNumericType)) {
                    return BOTTOM_PAIR;
                }
                ExternalSet<Type> set = this.commonNumericalType(left.elements, right.elements);
                if (set.isEmpty()) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(set));
            }
            case STRING_CONCAT: {
                if (left.elements.noneMatch(Type::isStringType) || right.elements.noneMatch(Type::isStringType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(StringType.INSTANCE));
            }
            case STRING_INDEX_OF: {
                if (left.elements.noneMatch(Type::isStringType) || right.elements.noneMatch(Type::isStringType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(IntType.INSTANCE));
            }
            case STRING_CONTAINS: 
            case STRING_ENDS_WITH: 
            case STRING_EQUALS: 
            case STRING_STARTS_WITH: {
                if (left.elements.noneMatch(Type::isStringType) || right.elements.noneMatch(Type::isStringType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(BoolType.INSTANCE));
            }
            case TYPE_CAST: {
                return this.evalTypeCast((BinaryExpression)null, left, right, state, pp);
            }
            case TYPE_CONV: {
                return this.evalTypeConv((BinaryExpression)null, left, right, state, pp);
            }
            case TYPE_CHECK: {
                if (right.elements.noneMatch(Type::isTypeTokenType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(BoolType.INSTANCE));
            }
        }
        return TOP_PAIR;
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalTernaryExpression(TernaryOperator operator, InferredTypes left, InferredTypes middle, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        switch (operator) {
            case STRING_SUBSTRING: {
                if (left.elements.noneMatch(Type::isStringType) || middle.elements.noneMatch(Type::isNumericType) || middle.elements.filter(Type::isNumericType).noneMatch(t -> t.asNumericType().isIntegral()) || right.elements.noneMatch(Type::isNumericType) || right.elements.filter(Type::isNumericType).noneMatch(t -> t.asNumericType().isIntegral())) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(StringType.INSTANCE));
            }
            case STRING_REPLACE: {
                if (left.elements.noneMatch(Type::isStringType) || middle.elements.noneMatch(Type::isStringType) || right.elements.noneMatch(Type::isStringType)) {
                    return BOTTOM_PAIR;
                }
                return this.mk(new InferredTypes(StringType.INSTANCE));
            }
        }
        return TOP_PAIR;
    }

    @Override
    protected SemanticDomain.Satisfiability satisfiesBinaryExpression(BinaryOperator operator, InferredTypes left, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        switch (operator) {
            case COMPARISON_EQ: 
            case COMPARISON_NE: {
                if (!left.elements.allMatch(Type::isTypeTokenType) || !right.elements.allMatch(Type::isTypeTokenType)) {
                    return SemanticDomain.Satisfiability.UNKNOWN;
                }
                ExternalSet<Type> lfiltered = left.elements.filter(Type::isTypeTokenType);
                ExternalSet<Type> rfiltered = right.elements.filter(Type::isTypeTokenType);
                if (operator == BinaryOperator.COMPARISON_EQ) {
                    if (left.elements.size() == 1 && left.elements.equals(right.elements)) {
                        return SemanticDomain.Satisfiability.SATISFIED;
                    }
                    if (!left.elements.intersects(right.elements) && !InferredTypes.typeTokensIntersect(lfiltered, rfiltered)) {
                        return SemanticDomain.Satisfiability.NOT_SATISFIED;
                    }
                    return SemanticDomain.Satisfiability.UNKNOWN;
                }
                if (!left.elements.intersects(right.elements) && !InferredTypes.typeTokensIntersect(lfiltered, rfiltered)) {
                    return SemanticDomain.Satisfiability.SATISFIED;
                }
                if (left.elements.size() == 1 && left.elements.equals(right.elements)) {
                    return SemanticDomain.Satisfiability.NOT_SATISFIED;
                }
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
            case TYPE_CHECK: {
                if (this.evalBinaryExpression(BinaryOperator.TYPE_CAST, left, right, state, pp).isBottom()) {
                    return SemanticDomain.Satisfiability.NOT_SATISFIED;
                }
                AtomicBoolean mightFail = new AtomicBoolean();
                ExternalSet<Type> set = this.cast(left.elements, right.elements, mightFail);
                if (left.elements.equals(set) && !mightFail.get()) {
                    return SemanticDomain.Satisfiability.SATISFIED;
                }
                return SemanticDomain.Satisfiability.UNKNOWN;
            }
        }
        return SemanticDomain.Satisfiability.UNKNOWN;
    }

    static boolean typeTokensIntersect(ExternalSet<Type> lfiltered, ExternalSet<Type> rfiltered) {
        for (Type l : lfiltered) {
            for (Type r : rfiltered) {
                if (!l.asTypeTokenType().getTypes().intersects(r.asTypeTokenType().getTypes())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected InferredTypes lubAux(InferredTypes other) throws SemanticException {
        return new InferredTypes(this.elements.union(other.elements));
    }

    @Override
    protected InferredTypes wideningAux(InferredTypes other) throws SemanticException {
        return this.lubAux(other);
    }

    @Override
    protected boolean lessOrEqualAux(InferredTypes other) throws SemanticException {
        return other.elements.contains(this.elements);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InferredTypes other = (InferredTypes)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    ExternalSet<Type> cast(ExternalSet<Type> types, ExternalSet<Type> tokens, AtomicBoolean mightFail) {
        if (mightFail != null) {
            mightFail.set(false);
        }
        ExternalSet<Type> result = Caches.types().mkEmptySet();
        for (Type token : tokens.filter(Type::isTypeTokenType).multiTransform(t -> t.asTypeTokenType().getTypes())) {
            for (Type t2 : types) {
                if (t2.canBeAssignedTo(token)) {
                    result.add(t2);
                    continue;
                }
                if (mightFail == null) continue;
                mightFail.set(true);
            }
        }
        return result;
    }

    ExternalSet<Type> convert(ExternalSet<Type> types, ExternalSet<Type> tokens) {
        ExternalSet<Type> result = Caches.types().mkEmptySet();
        for (Type token : tokens.filter(Type::isTypeTokenType).multiTransform(t -> t.asTypeTokenType().getTypes())) {
            for (Type t2 : types) {
                if (!t2.canBeAssignedTo(token)) continue;
                result.add(token);
            }
        }
        return result;
    }

    ExternalSet<Type> commonNumericalType(ExternalSet<Type> left, ExternalSet<Type> right) {
        if (left.noneMatch(Type::isNumericType) && right.noneMatch(Type::isNumericType)) {
            return Caches.types().mkEmptySet();
        }
        ExternalSet<Type> result = Caches.types().mkEmptySet();
        for (Type t1 : left.filter(type -> type.isNumericType() || type.isUntyped())) {
            for (Type t2 : right.filter(type -> type.isNumericType() || type.isUntyped())) {
                if (t1.isUntyped() && t2.isUntyped()) {
                    result.add(t1);
                    continue;
                }
                if (t1.isUntyped()) {
                    result.add(t2);
                    continue;
                }
                if (t2.isUntyped()) {
                    result.add(t1);
                    continue;
                }
                result.add(t1.commonSupertype(t2));
            }
        }
        return result;
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalTypeCast(BinaryExpression cast, InferredTypes left, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        if (right.elements.noneMatch(Type::isTypeTokenType)) {
            return BOTTOM_PAIR;
        }
        ExternalSet<Type> set = this.cast(left.elements, right.elements, null);
        if (set.isEmpty()) {
            return BOTTOM_PAIR;
        }
        return this.mk(new InferredTypes(set));
    }

    @Override
    protected InferredValue.InferredPair<InferredTypes> evalTypeConv(BinaryExpression conv, InferredTypes left, InferredTypes right, InferredTypes state, ProgramPoint pp) {
        if (right.elements.noneMatch(Type::isTypeTokenType)) {
            return BOTTOM_PAIR;
        }
        ExternalSet<Type> set = this.convert(left.elements, right.elements);
        if (set.isEmpty()) {
            return BOTTOM_PAIR;
        }
        return this.mk(new InferredTypes(set));
    }

    @Override
    public boolean tracksIdentifiers(Identifier id) {
        return !(id instanceof MemoryPointer);
    }

    @Override
    public boolean canProcess(SymbolicExpression expression) {
        return true;
    }
}

