/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.syntactic;

import it.unive.lisa.checks.warnings.CFGDescriptorWarning;
import it.unive.lisa.checks.warnings.CFGWarning;
import it.unive.lisa.checks.warnings.ExpressionWarning;
import it.unive.lisa.checks.warnings.GlobalWarning;
import it.unive.lisa.checks.warnings.StatementWarning;
import it.unive.lisa.checks.warnings.UnitWarning;
import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CFGDescriptor;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

public class CheckTool {
    private final Collection<Warning> warnings = Collections.newSetFromMap(new ConcurrentHashMap());

    public CheckTool() {
    }

    protected CheckTool(CheckTool other) {
        this();
        this.warnings.addAll(other.warnings);
    }

    public void warn(String message) {
        this.warnings.add(new Warning(message));
    }

    public void warnOn(Unit unit, String message) {
        this.warnings.add(new UnitWarning(unit, message));
    }

    public void warnOn(Unit unit, Global global, String message) {
        this.warnings.add(new GlobalWarning(unit, global, message));
    }

    public void warnOn(CFG cfg, String message) {
        this.warnings.add(new CFGWarning(cfg, message));
    }

    public void warnOn(CFGDescriptor descriptor, String message) {
        this.warnings.add(new CFGDescriptorWarning(descriptor, message));
    }

    public void warnOn(Statement statement, String message) {
        if (statement instanceof Expression) {
            this.warnOn((Expression)statement, message);
        } else {
            this.warnings.add(new StatementWarning(statement, message));
        }
    }

    public void warnOn(Expression expression, String message) {
        this.warnings.add(new ExpressionWarning(expression, message));
    }

    public Collection<Warning> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }
}

