/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.warnings;

import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.checks.warnings.WarningWithLocation;
import it.unive.lisa.program.cfg.CFG;
import org.apache.commons.lang3.StringUtils;

public class CFGWarning
extends WarningWithLocation {
    private final CFG cfg;

    public CFGWarning(CFG cfg, String message) {
        super(cfg.getDescriptor().getLocation(), message);
        this.cfg = cfg;
    }

    public final CFG getCFG() {
        return this.cfg;
    }

    @Override
    public int compareTo(Warning o) {
        int cmp = super.compareTo(o);
        if (cmp != 0) {
            return cmp;
        }
        if (!(o instanceof CFGWarning)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        CFGWarning other = (CFGWarning)o;
        cmp = StringUtils.compare((String)this.cfg.getDescriptor().toString(), (String)other.cfg.getDescriptor().toString());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cfg == null ? 0 : this.cfg.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CFGWarning other = (CFGWarning)obj;
        return !(this.cfg == null ? other.cfg != null : !this.cfg.equals(other.cfg));
    }

    @Override
    public String getTag() {
        return "CFG";
    }

    @Override
    public String toString() {
        return this.getLocationWithBrackets() + " on '" + this.cfg.getDescriptor().getFullSignatureWithParNames() + "': " + this.getTaggedMessage();
    }
}

