/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.checks.warnings;

import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.checks.warnings.WarningWithLocation;
import it.unive.lisa.program.cfg.statement.Statement;

public class StatementWarning
extends WarningWithLocation {
    private final Statement statement;

    public StatementWarning(Statement statement, String message) {
        super(statement.getLocation(), message);
        this.statement = statement;
    }

    public final Statement getStatement() {
        return this.statement;
    }

    @Override
    public int compareTo(Warning o) {
        int cmp = super.compareTo(o);
        if (cmp != 0) {
            return cmp;
        }
        if (!(o instanceof StatementWarning)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        StatementWarning other = (StatementWarning)o;
        cmp = this.statement.compareTo(other.statement);
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementWarning other = (StatementWarning)obj;
        return !(this.statement == null ? other.statement != null : !this.statement.equals(other.statement));
    }

    @Override
    public String getTag() {
        return "STATEMENT";
    }

    @Override
    public String toString() {
        return this.getLocationWithBrackets() + " on '" + this.statement.getCFG().getDescriptor().getFullSignatureWithParNames() + "': " + this.getTaggedMessage();
    }
}

