/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.interprocedural.callgraph;

import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallGraphConstructionException;
import it.unive.lisa.interprocedural.callgraph.CallGraphEdge;
import it.unive.lisa.interprocedural.callgraph.CallGraphNode;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.outputs.DotGraph;
import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.NativeCFG;
import it.unive.lisa.program.cfg.statement.CFGCall;
import it.unive.lisa.program.cfg.statement.Call;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.HybridCall;
import it.unive.lisa.program.cfg.statement.OpenCall;
import it.unive.lisa.program.cfg.statement.UnresolvedCall;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.datastructures.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class BaseCallGraph
extends Graph<BaseCallGraph, CallGraphNode, CallGraphEdge>
implements CallGraph {
    private Program program;

    @Override
    public final void init(Program program) throws CallGraphConstructionException {
        this.program = program;
    }

    @Override
    public final Call resolve(UnresolvedCall call) throws CallResolutionException {
        CallGraphNode t;
        ArrayList<CFG> targets = new ArrayList<CFG>();
        ArrayList<NativeCFG> nativeTargets = new ArrayList<NativeCFG>();
        if (call.isInstanceCall()) {
            if (call.getParameters().length == 0) {
                throw new CallResolutionException("An instance call should have at least one parameter to be used as the receiver of the call");
            }
            Expression receiver = call.getParameters()[0];
            for (Type recType : this.getPossibleTypesOfReceiver(receiver)) {
                if (!recType.isUnitType()) continue;
                CompilationUnit compilationUnit = recType.asUnitType().getUnit();
                Collection<CodeMember> candidates = compilationUnit.getInstanceCodeMembersByName(call.getTargetName(), true);
                for (CodeMember cm : candidates) {
                    if (!cm.getDescriptor().isInstance() || !call.getStrategy().matches(cm.getDescriptor().getArgs(), call.getParameters())) continue;
                    if (cm instanceof CFG) {
                        targets.add((CFG)cm);
                        continue;
                    }
                    nativeTargets.add((NativeCFG)cm);
                }
            }
        } else {
            for (CodeMember cm : this.program.getAllCodeMembers()) {
                if (cm.getDescriptor().isInstance() || !cm.getDescriptor().getName().equals(call.getTargetName()) || !call.getStrategy().matches(cm.getDescriptor().getArgs(), call.getParameters())) continue;
                if (cm instanceof CFG) {
                    targets.add((CFG)cm);
                    continue;
                }
                nativeTargets.add((NativeCFG)cm);
            }
        }
        Call resolved = targets.isEmpty() && nativeTargets.isEmpty() ? new OpenCall(call.getCFG(), call.getLocation(), call.getTargetName(), call.getStaticType(), call.getParameters()) : (nativeTargets.isEmpty() ? new CFGCall(call.getCFG(), call.getLocation(), call.getTargetName(), targets, call.getParameters()) : new HybridCall(call.getCFG(), call.getLocation(), call.getTargetName(), targets, nativeTargets, call.getParameters()));
        resolved.setOffset(call.getOffset());
        CallGraphNode source = new CallGraphNode(this, call.getCFG());
        if (!this.adjacencyMatrix.containsNode(source)) {
            this.addNode(source, this.program.getEntryPoints().contains(call.getCFG()));
        }
        for (CFG cFG : targets) {
            t = new CallGraphNode(this, cFG);
            if (!this.adjacencyMatrix.containsNode(t)) {
                this.addNode(t, this.program.getEntryPoints().contains(call.getCFG()));
            }
            this.addEdge(new CallGraphEdge(source, t));
        }
        for (NativeCFG nativeCFG : nativeTargets) {
            t = new CallGraphNode(this, nativeCFG);
            if (!this.adjacencyMatrix.containsNode(t)) {
                this.addNode(t, false);
            }
            this.addEdge(new CallGraphEdge(source, t));
        }
        return resolved;
    }

    protected abstract Collection<Type> getPossibleTypesOfReceiver(Expression var1);

    @Override
    public Collection<CodeMember> getCallees(CodeMember cm) {
        return this.followersOf(new CallGraphNode(this, cm)).stream().map(CallGraphNode::getCodeMember).collect(Collectors.toList());
    }

    @Override
    public Collection<CodeMember> getCallers(CodeMember cm) {
        return this.predecessorsOf(new CallGraphNode(this, cm)).stream().map(CallGraphNode::getCodeMember).collect(Collectors.toList());
    }

    @Override
    protected DotGraph<CallGraphNode, CallGraphEdge, BaseCallGraph> toDot(Function<CallGraphNode, String> labelGenerator) {
        throw new UnsupportedOperationException();
    }
}

