/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.logging;

import it.unive.lisa.logging.Counter;
import it.unive.lisa.logging.CountingIterable;
import it.unive.lisa.util.collections.IterableArray;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public final class IterationLogger {
    private IterationLogger() {
    }

    public static <E> Iterable<E> iterate(Logger logger, E[] array, String message, String objects) {
        return IterationLogger.iterate(logger, Level.INFO, new IterableArray<E>(array), message, objects, array.length);
    }

    public static <E> Iterable<E> iterate(Logger logger, Level level, E[] array, String message, String objects) {
        return IterationLogger.iterate(logger, level, new IterableArray<E>(array), message, objects, array.length);
    }

    public static <E> Iterable<E> iterate(Logger logger, Collection<E> collection, String message, String objects) {
        return IterationLogger.iterate(logger, Level.INFO, collection, message, objects, collection.size());
    }

    public static <E> Iterable<E> iterate(Logger logger, Level level, Collection<E> collection, String message, String objects) {
        return IterationLogger.iterate(logger, level, collection, message, objects, collection.size());
    }

    public static <E> Iterable<E> iterate(Logger logger, Iterable<E> iterable, String message, String objects) {
        return IterationLogger.iterate(logger, Level.INFO, iterable, message, objects);
    }

    public static <E> Iterable<E> iterate(Logger logger, Level level, Iterable<E> iterable, String message, String objects) {
        int size = 0;
        Iterator<E> it = iterable.iterator();
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return IterationLogger.iterate(logger, level, iterable, message, objects, size);
    }

    public static <E> Iterable<E> iterate(Logger logger, Stream<E> stream, String message, String objects) {
        return IterationLogger.iterate(logger, Level.INFO, stream, message, objects);
    }

    public static <E> Iterable<E> iterate(Logger logger, Level level, Stream<E> stream, String message, String objects) {
        List list = stream.collect(Collectors.toList());
        return IterationLogger.iterate(logger, level, list, message, objects, list.size());
    }

    private static <E> Iterable<E> iterate(Logger logger, Level level, Iterable<E> it, String message, String objects, int size) {
        return new CountingIterable<E>(it, new Counter(logger, level, message, objects, size, 0.025));
    }
}

