/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs;

import it.unive.lisa.outputs.DotGraph;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.edge.FalseEdge;
import it.unive.lisa.program.cfg.edge.TrueEdge;
import it.unive.lisa.program.cfg.statement.Statement;
import java.util.function.Function;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;

public final class DotCFG
extends DotGraph<Statement, Edge, CFG> {
    private DotCFG(String title) {
        super(title, new CFGLegend().graph);
    }

    public static DotCFG fromCFG(CFG source, String title, Function<Statement, String> labelGenerator) {
        DotCFG graph = new DotCFG(title);
        for (Statement node : source.getEntrypoints()) {
            graph.addNode(node, true, node.stopsExecution(), labelGenerator);
        }
        for (Statement node : source.getNodes()) {
            if (source.getEntrypoints().contains(node)) continue;
            graph.addNode(node, false, node.stopsExecution(), labelGenerator);
        }
        for (Statement src : source.getNodes()) {
            for (Statement dest : source.followersOf(src)) {
                Edge edge = (Edge)source.getEdgeConnecting(src, dest);
                if (edge instanceof TrueEdge) {
                    graph.addEdge(edge, "blue", "dashed");
                    continue;
                }
                if (edge instanceof FalseEdge) {
                    graph.addEdge(edge, "red", "dashed");
                    continue;
                }
                graph.addEdge(edge, "black", null);
            }
        }
        return graph;
    }

    private static final class CFGLegend {
        private final Graph graph = new MultiGraph("legend");

        private CFGLegend() {
            Node l = this.graph.addNode("legend");
            StringBuilder builder = new StringBuilder();
            builder.append("<");
            builder.append("<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" cellborder=\"0\">");
            builder.append("<tr><td align=\"right\">node border&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("gray");
            builder.append("\">");
            builder.append("gray");
            builder.append("</font>, single</td></tr>");
            builder.append("<tr><td align=\"right\">entrypoint border&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("black");
            builder.append("\">");
            builder.append("black");
            builder.append("</font>, single</td></tr>");
            builder.append("<tr><td align=\"right\">exitpoint border&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("black");
            builder.append("\">");
            builder.append("black");
            builder.append("</font>, double</td></tr>");
            builder.append("<tr><td align=\"right\">sequential edge&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("black");
            builder.append("\">");
            builder.append("black");
            builder.append("</font>, solid</td></tr>");
            builder.append("<tr><td align=\"right\">true edge&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("blue");
            builder.append("\">");
            builder.append("blue");
            builder.append("</font>, ");
            builder.append("dashed");
            builder.append("</td></tr>");
            builder.append("<tr><td align=\"right\">false edge&nbsp;</td><td align=\"left\"><font color=\"");
            builder.append("red");
            builder.append("\">");
            builder.append("red");
            builder.append("</font>, ");
            builder.append("dashed");
            builder.append("</td></tr>");
            builder.append("</table>");
            builder.append(">");
            l.setAttribute("label", new Object[]{builder.toString()});
        }
    }
}

