/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.outputs;

import it.unive.lisa.util.datastructures.graph.Graph;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSinkDOT;
import org.graphstream.stream.file.FileSourceDOT;

public abstract class DotGraph<N extends it.unive.lisa.util.datastructures.graph.Node<N, E, G>, E extends it.unive.lisa.util.datastructures.graph.Edge<N, E, G>, G extends Graph<G, N, E>> {
    protected static final String COLOR_BLACK = "black";
    protected static final String COLOR_GRAY = "gray";
    protected static final String COLOR_RED = "red";
    protected static final String COLOR_BLUE = "blue";
    protected static final String STYLE = "style";
    protected static final String COLOR = "color";
    protected static final String SHAPE = "shape";
    protected static final String LABEL = "label";
    protected static final String EXIT_NODE_EXTRA_ATTR = "peripheries";
    protected static final String NODE_SHAPE = "rect";
    protected static final String EXIT_NODE_EXTRA_VALUE = "2";
    protected static final String SPECIAL_NODE_COLOR = "black";
    protected static final String NORMAL_NODE_COLOR = "gray";
    protected static final String CONDITIONAL_EDGE_STYLE = "dashed";
    private final org.graphstream.graph.Graph graph;
    private final org.graphstream.graph.Graph legend;
    private final String title;
    private final Map<N, Long> codes = new IdentityHashMap<N, Long>();
    private long nextCode;

    protected DotGraph(String title, org.graphstream.graph.Graph legend) {
        this.graph = new MultiGraph("graph");
        this.legend = legend;
        this.title = title;
    }

    private static String dotEscape(String extraLabel) {
        String escapeHtml4 = StringEscapeUtils.escapeHtml4((String)extraLabel);
        String replace = escapeHtml4.replace("\n", "<BR/>");
        return replace.replace("\\", "\\\\");
    }

    protected void addNode(N node, boolean entry, boolean exit, Function<N, String> labelGenerator) {
        Node n = this.graph.addNode(DotGraph.nodeName(this.codes.computeIfAbsent(node, nn -> this.nextCode++)));
        n.setAttribute(SHAPE, new Object[]{NODE_SHAPE});
        if (entry || exit) {
            n.setAttribute(COLOR, new Object[]{"black"});
        } else {
            n.setAttribute(COLOR, new Object[]{"gray"});
        }
        if (exit) {
            n.setAttribute(EXIT_NODE_EXTRA_ATTR, new Object[]{EXIT_NODE_EXTRA_VALUE});
        }
        String label = DotGraph.dotEscape(node.toString());
        Object extraLabel = labelGenerator.apply(node);
        if (!((String)extraLabel).isEmpty()) {
            extraLabel = "<BR/>" + DotGraph.dotEscape((String)extraLabel);
        }
        n.setAttribute(LABEL, new Object[]{"<" + label + (String)extraLabel + ">"});
    }

    private static String nodeName(long id) {
        return "node" + id;
    }

    protected void addEdge(E edge, String color, String style) {
        long id = this.codes.computeIfAbsent(edge.getSource(), n -> this.nextCode++);
        long id1 = this.codes.computeIfAbsent(edge.getDestination(), n -> this.nextCode++);
        Edge e = this.graph.addEdge("edge-" + id + "-" + id1, DotGraph.nodeName(id), DotGraph.nodeName(id1), true);
        if (style != null) {
            e.setAttribute(STYLE, new Object[]{style});
        }
        if (color != null) {
            e.setAttribute(COLOR, new Object[]{color});
        }
    }

    public void dumpDot(Writer writer) throws IOException {
        CustomDotSink sink = new CustomDotSink(){

            protected void outputEndOfFile() throws IOException {
                if (DotGraph.this.legend != null) {
                    LegendClusterSink legend = new LegendClusterSink();
                    legend.setDirected(true);
                    StringWriter sw = new StringWriter();
                    legend.writeAll(DotGraph.this.legend, sw);
                    this.out.printf("%s%n", sw.toString());
                }
                super.outputEndOfFile();
            }
        };
        sink.setDirected(true);
        sink.writeAll(this.graph, writer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DotGraph other = (DotGraph)obj;
        if (this.graph == null) {
            if (other.graph != null) {
                return false;
            }
        } else {
            if (other.graph == null) {
                return false;
            }
            if (!DotGraph.sameGraphs(this.graph, other.graph)) {
                return false;
            }
        }
        return true;
    }

    private static boolean sameGraphs(org.graphstream.graph.Graph first, org.graphstream.graph.Graph second) {
        if (first.getNodeCount() != second.getNodeCount()) {
            return false;
        }
        if (first.getEdgeCount() != second.getEdgeCount()) {
            return false;
        }
        IdentityHashMap<Node, String> fMapping = new IdentityHashMap<Node, String>();
        IdentityHashMap<Node, String> sMapping = new IdentityHashMap<Node, String>();
        ArrayList<String> fNodes = new ArrayList<String>();
        ArrayList<String> sNodes = new ArrayList<String>();
        ArrayList<String> fEntries = new ArrayList<String>();
        ArrayList<String> sEntries = new ArrayList<String>();
        ArrayList<String> fExits = new ArrayList<String>();
        ArrayList<String> sExits = new ArrayList<String>();
        DotGraph.parseNodes(first, fMapping, fNodes, fEntries, fExits);
        DotGraph.parseNodes(second, sMapping, sNodes, sEntries, sExits);
        if (!(fEntries.equals(sEntries) && fExits.equals(sExits) && fNodes.equals(sNodes))) {
            return false;
        }
        ArrayList<String> fEdges = new ArrayList<String>();
        ArrayList<String> sEdges = new ArrayList<String>();
        DotGraph.parseEdges(first, fMapping, fNodes, fEdges);
        DotGraph.parseEdges(second, sMapping, sNodes, sEdges);
        return fEdges.equals(sEdges);
    }

    private static void parseEdges(org.graphstream.graph.Graph g, Map<Node, String> mapping, List<String> nodes, List<String> edges) {
        g.edges().forEach(e -> {
            int source = nodes.indexOf(mapping.get(e.getSourceNode()));
            int dest = nodes.indexOf(mapping.get(e.getTargetNode()));
            Object middle = "";
            if (e.hasAttribute(STYLE)) {
                middle = (String)middle + "_" + e.getAttribute(STYLE) + "_";
            }
            if (e.hasAttribute(COLOR)) {
                middle = (String)middle + "_" + e.getAttribute(COLOR) + "_";
            }
            edges.add(source + (String)middle + dest);
        });
        Collections.sort(edges);
    }

    private static void parseNodes(org.graphstream.graph.Graph g, Map<Node, String> mapping, List<String> nodes, List<String> entries, List<String> exits) {
        g.nodes().forEach(n -> {
            String label = (String)n.getAttribute(LABEL, String.class);
            mapping.put((Node)n, label);
            nodes.add(label);
            if (n.hasArray(COLOR) && n.getAttribute(COLOR).equals("black")) {
                if (n.hasAttribute(EXIT_NODE_EXTRA_ATTR) && n.getAttribute(EXIT_NODE_EXTRA_ATTR).equals(EXIT_NODE_EXTRA_VALUE)) {
                    exits.add(label);
                } else {
                    entries.add(label);
                }
            }
        });
        Collections.sort(nodes);
        Collections.sort(entries);
        Collections.sort(exits);
    }

    public String toString() {
        return this.graph.toString();
    }

    public static <N extends it.unive.lisa.util.datastructures.graph.Node<N, E, G>, E extends it.unive.lisa.util.datastructures.graph.Edge<N, E, G>, G extends Graph<G, N, E>> DotGraph<N, E, G> readDot(Reader reader) throws IOException {
        String content;
        String sentinel = "label=<";
        String replacement = "label=\"<";
        String ending = ">];";
        String endingReplacement = ">\"];";
        try (BufferedReader br = new BufferedReader(reader);
             StringWriter writer = new StringWriter();){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith(LABEL)) continue;
                int i = line.indexOf(sentinel);
                if (i != -1) {
                    writer.append(line.substring(0, i));
                    writer.append(replacement);
                    writer.append(line.substring(i + sentinel.length(), line.length() - ending.length()));
                    writer.append(endingReplacement);
                } else {
                    if (line.startsWith("subgraph")) {
                        writer.append("}");
                        break;
                    }
                    writer.append(line);
                }
                writer.append("\n");
            }
            content = writer.toString();
        }
        FileSourceDOT source = new FileSourceDOT();
        DotGraph graph = new DotGraph<N, E, G>(null, null){};
        source.addSink((Sink)graph.graph);
        try (StringReader sr = new StringReader(content);){
            source.readAll((Reader)sr);
        }
        catch (Exception e) {
            System.out.println();
        }
        return graph;
    }

    private class LegendClusterSink
    extends CustomDotSink {
        private LegendClusterSink() {
        }

        @Override
        protected void outputHeader() throws IOException {
            this.out = (PrintWriter)this.output;
            this.out.printf("%s {%n", "subgraph cluster_legend");
            this.out.printf("\tlabel=\"Legend\";%n", new Object[0]);
            this.out.printf("\tstyle=dotted;%n", new Object[0]);
            this.out.printf("\tnode [shape=plaintext];%n", new Object[0]);
        }
    }

    private class CustomDotSink
    extends FileSinkDOT {
        private CustomDotSink() {
        }

        protected void outputHeader() throws IOException {
            this.out = (PrintWriter)this.output;
            this.out.printf("%s {%n", "digraph");
            if (DotGraph.this.title != null) {
                this.out.printf("\tlabelloc=\"t\";%n", new Object[0]);
                this.out.printf("\tlabel=\"" + DotGraph.this.title + "\";%n", new Object[0]);
            }
        }

        protected String outputAttribute(String key, Object value, boolean first) {
            boolean quote = true;
            if (value instanceof Number || key.equals(DotGraph.LABEL)) {
                quote = false;
            }
            String quoting = quote ? "\"" : "";
            return String.format("%s%s=%s%s%s", first ? "" : ",", key, quoting, value, quoting);
        }

        protected String outputAttributes(Element e) {
            String result;
            if (e.getAttributeCount() == 0) {
                return "";
            }
            HashMap attrs = new HashMap();
            e.attributeKeys().forEach(key -> attrs.put(key, this.outputAttribute((String)key, e.getAttribute(key), true)));
            StringBuilder buffer = new StringBuilder("[");
            for (Map.Entry entry : attrs.entrySet()) {
                if (((String)entry.getKey()).equals(DotGraph.LABEL)) continue;
                buffer.append((String)entry.getValue()).append(",");
            }
            if (attrs.containsKey(DotGraph.LABEL)) {
                buffer.append((String)attrs.get(DotGraph.LABEL));
            }
            if ((result = buffer.toString()).endsWith(",")) {
                result = result.substring(0, result.length() - 1);
            }
            return result + "]";
        }
    }
}

