/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.CodeElement;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CFGDescriptor;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.NativeCFG;
import it.unive.lisa.program.cfg.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class CompilationUnit
extends Unit
implements CodeElement {
    private final CodeLocation location;
    private final Collection<CompilationUnit> superUnits;
    private final Collection<CompilationUnit> instances;
    private final Map<String, Global> instanceGlobals;
    private final Map<String, CFG> instanceCfgs;
    private final Map<String, NativeCFG> instanceConstructs;
    private final boolean sealed;
    private boolean hierarchyComputed;
    private Annotations annotations;

    public CompilationUnit(CodeLocation location, String name, boolean sealed) {
        super(name);
        Objects.requireNonNull(location, "The location of a unit cannot be null.");
        this.location = location;
        this.sealed = sealed;
        this.superUnits = Collections.newSetFromMap(new ConcurrentHashMap());
        this.instances = Collections.newSetFromMap(new ConcurrentHashMap());
        this.instanceGlobals = new ConcurrentHashMap<String, Global>();
        this.instanceCfgs = new ConcurrentHashMap<String, CFG>();
        this.instanceConstructs = new ConcurrentHashMap<String, NativeCFG>();
        this.hierarchyComputed = false;
        this.annotations = new Annotations();
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final Collection<CompilationUnit> getSuperUnits() {
        return this.superUnits;
    }

    public final Collection<CompilationUnit> getInstances() {
        return this.instances;
    }

    public final Collection<Global> getInstanceGlobals(boolean traverseHierarchy) {
        return this.searchGlobals(g -> true, traverseHierarchy);
    }

    public final Collection<CFG> getInstanceCFGs(boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> true, true, false, traverseHierarchy);
    }

    public final Collection<NativeCFG> getInstanceConstructs(boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> true, false, true, traverseHierarchy);
    }

    public final boolean addSuperUnit(CompilationUnit unit) {
        return this.superUnits.add(unit);
    }

    public final boolean addInstanceGlobal(Global global) {
        return this.instanceGlobals.putIfAbsent(global.getName(), global) == null;
    }

    public final boolean addInstanceCFG(CFG cfg) {
        CFG c = this.instanceCfgs.putIfAbsent(cfg.getDescriptor().getSignature(), cfg);
        if (this.sealed) {
            if (c == null) {
                cfg.getDescriptor().setOverridable(false);
            } else {
                c.getDescriptor().setOverridable(false);
            }
        }
        return c == null;
    }

    public final boolean addInstanceConstruct(NativeCFG construct) {
        NativeCFG c = this.instanceConstructs.putIfAbsent(construct.getDescriptor().getSignature(), construct);
        if (this.sealed) {
            if (c == null) {
                construct.getDescriptor().setOverridable(false);
            } else {
                c.getDescriptor().setOverridable(false);
            }
        }
        return c == null;
    }

    public final CFG getInstanceCFG(String signature, boolean traverseHierarchy) {
        Collection res = this.searchCodeMembers(cm -> cm.getDescriptor().getSignature().equals(signature), true, false, traverseHierarchy);
        if (res.isEmpty()) {
            return null;
        }
        return (CFG)res.stream().findFirst().get();
    }

    public final NativeCFG getInstanceConstruct(String signature, boolean traverseHierarchy) {
        Collection res = this.searchCodeMembers(cm -> cm.getDescriptor().getSignature().equals(signature), false, true, traverseHierarchy);
        if (res.isEmpty()) {
            return null;
        }
        return (NativeCFG)res.stream().findFirst().get();
    }

    public final Global getInstanceGlobal(String name, boolean traverseHierarchy) {
        Collection<Global> res = this.searchGlobals(cm -> cm.getName().equals(name), traverseHierarchy);
        if (res.isEmpty()) {
            return null;
        }
        return res.stream().findFirst().get();
    }

    public final CodeMember getInstanceCodeMember(String signature, boolean traverseHierarchy) {
        Collection res = this.searchCodeMembers(cm -> cm.getDescriptor().getSignature().equals(signature), true, true, traverseHierarchy);
        if (res.isEmpty()) {
            return null;
        }
        return (CodeMember)res.stream().findFirst().get();
    }

    public final Collection<CFG> getInstanceCFGsByName(String name, boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm.getDescriptor().getName().equals(name), true, false, traverseHierarchy);
    }

    public final Collection<NativeCFG> getInstanceConstructsByName(String name, boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm.getDescriptor().getName().equals(name), false, true, traverseHierarchy);
    }

    public final Collection<CodeMember> getInstanceCodeMembersByName(String name, boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm.getDescriptor().getName().equals(name), true, true, traverseHierarchy);
    }

    public final Collection<CodeMember> getMatchingInstanceCodeMembers(CFGDescriptor signature, boolean traverseHierarchy) {
        return this.searchCodeMembers(cm -> cm.getDescriptor().matchesSignature(signature), true, true, traverseHierarchy);
    }

    private <T extends CodeMember> Collection<T> searchCodeMembers(Predicate<CodeMember> filter, boolean cfgs, boolean constructs, boolean traverseHierarchy) {
        HashSet<CodeMember> result = new HashSet<CodeMember>();
        if (cfgs) {
            for (CFG cfg2 : this.instanceCfgs.values()) {
                if (!filter.test(cfg2)) continue;
                result.add(cfg2);
            }
        }
        if (constructs) {
            for (NativeCFG construct : this.instanceConstructs.values()) {
                if (!filter.test(construct)) continue;
                result.add(construct);
            }
        }
        if (!traverseHierarchy) {
            return result;
        }
        for (CompilationUnit cu : this.superUnits) {
            for (CodeMember sup : cu.searchCodeMembers(filter, cfgs, constructs, true)) {
                if (result.stream().anyMatch(cfg -> sup.getDescriptor().overriddenBy().contains(cfg))) continue;
                result.add(sup);
            }
        }
        return result;
    }

    private Collection<Global> searchGlobals(Predicate<Global> filter, boolean traverseHierarchy) {
        HashMap<String, Global> result = new HashMap<String, Global>();
        for (Global g : this.instanceGlobals.values()) {
            if (!filter.test(g)) continue;
            result.put(g.getName(), g);
        }
        if (!traverseHierarchy) {
            return result.values();
        }
        for (CompilationUnit cu : this.superUnits) {
            for (Global sup : cu.searchGlobals(filter, true)) {
                if (result.containsKey(sup.getName())) continue;
                result.put(sup.getName(), sup);
            }
        }
        return result.values();
    }

    @Override
    public Collection<CFG> getAllCFGs() {
        Collection<CFG> all = super.getAllCFGs();
        this.instanceCfgs.values().forEach(all::add);
        return all;
    }

    @Override
    public Collection<Global> getAllGlobals() {
        Collection<Global> all = super.getAllGlobals();
        this.instanceGlobals.values().forEach(all::add);
        return all;
    }

    @Override
    public Collection<NativeCFG> getAllConstructs() {
        Collection<NativeCFG> all = super.getAllConstructs();
        this.instanceConstructs.values().forEach(all::add);
        return all;
    }

    public final Collection<CodeMember> getInstanceCodeMembers(boolean traverseHierarchy) {
        HashSet<CodeMember> all = new HashSet<CodeMember>(this.getInstanceCFGs(traverseHierarchy));
        all.addAll(this.getInstanceConstructs(traverseHierarchy));
        return all;
    }

    public final boolean isInstanceOf(CompilationUnit unit) {
        return this == unit || (this.hierarchyComputed ? unit.instances.contains(this) : this.superUnits.stream().anyMatch(u -> u.isInstanceOf(unit)));
    }

    private final void addInstance(CompilationUnit unit) throws ProgramValidationException {
        if (this.superUnits.contains(unit)) {
            throw new ProgramValidationException("Found loop in compilation units hierarchy: " + unit + " is both a super unit and an instance of " + this);
        }
        this.instances.add(unit);
        for (CompilationUnit sup : this.superUnits) {
            sup.addInstance(unit);
        }
    }

    @Override
    public final void validateAndFinalize() throws ProgramValidationException {
        if (this.hierarchyComputed) {
            return;
        }
        super.validateAndFinalize();
        for (CompilationUnit sup : this.superUnits) {
            if (sup.sealed) {
                throw new ProgramValidationException(this + " cannot inherit from the sealed unit " + sup);
            }
            sup.validateAndFinalize();
        }
        this.addInstance(this);
        for (CodeMember cfg : this.getInstanceCodeMembers(false)) {
            Collection<CodeMember> matching = this.getMatchingInstanceCodeMembers(cfg.getDescriptor(), false);
            if (matching.size() == 1 && matching.iterator().next() == cfg) continue;
            throw new ProgramValidationException(cfg.getDescriptor().getSignature() + " is duplicated within unit " + this);
        }
        for (CompilationUnit s : this.superUnits) {
            for (CodeMember sup : s.getInstanceCodeMembers(true)) {
                Collection<CodeMember> overriding = this.getMatchingInstanceCodeMembers(sup.getDescriptor(), false);
                if (overriding.size() > 1) {
                    throw new ProgramValidationException(sup.getDescriptor().getSignature() + " is overriden multiple times in unit " + this + ": " + StringUtils.join((Object[])new Object[]{", ", overriding}));
                }
                if (overriding.isEmpty()) continue;
                if (!sup.getDescriptor().isOverridable()) {
                    throw new ProgramValidationException(this + " overrides the non-overridable cfg " + sup.getDescriptor().getSignature());
                }
                CodeMember over = overriding.iterator().next();
                over.getDescriptor().overrides().addAll(sup.getDescriptor().overrides());
                over.getDescriptor().overrides().add(sup);
                over.getDescriptor().overrides().forEach(c -> c.getDescriptor().overriddenBy().add(over));
            }
        }
        for (CompilationUnit superUnit : this.superUnits) {
            for (Annotation ann : superUnit.getAnnotations()) {
                if (ann.isInherited()) continue;
                this.addAnnotation(ann);
            }
        }
        for (CodeMember instCfg : this.getInstanceCodeMembers(false)) {
            for (CodeMember matching : instCfg.getDescriptor().overrides()) {
                for (Annotation ann : matching.getDescriptor().getAnnotations()) {
                    if (!ann.isInherited()) {
                        instCfg.getDescriptor().addAnnotation(ann);
                    }
                    Parameter[] args = instCfg.getDescriptor().getArgs();
                    Parameter[] superArgs = matching.getDescriptor().getArgs();
                    for (int i = 0; i < args.length; ++i) {
                        for (Annotation parAnn : superArgs[i].getAnnotations()) {
                            if (parAnn.isInherited()) continue;
                            args[i].addAnnotation(parAnn);
                        }
                    }
                }
            }
        }
        this.hierarchyComputed = true;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.addAnnotation(ann);
    }

    @Override
    public CodeLocation getLocation() {
        return this.location;
    }
}

