/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.NativeCFG;
import it.unive.lisa.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Program
extends Unit {
    public static final String PROGRAM_NAME = "~LiSAProgram";
    private final Map<String, CompilationUnit> units = new ConcurrentHashMap<String, CompilationUnit>();
    private final Collection<CFG> entrypoints;
    private Collection<Type> types = new ArrayList<Type>();

    public Program() {
        super(PROGRAM_NAME);
        this.entrypoints = new HashSet<CFG>();
    }

    public final boolean registerType(Type type) {
        return this.types.add(type);
    }

    public final Collection<Type> getRegisteredTypes() {
        return this.types;
    }

    public final boolean addCompilationUnit(CompilationUnit unit) {
        return this.units.putIfAbsent(unit.getName(), unit) == null;
    }

    public final boolean addEntryPoint(CFG method) {
        return this.entrypoints.add(method);
    }

    public final Collection<CFG> getEntryPoints() {
        return this.entrypoints;
    }

    public final Collection<CompilationUnit> getUnits() {
        return this.units.values();
    }

    public final CompilationUnit getUnit(String name) {
        return this.units.get(name);
    }

    @Override
    public Collection<CFG> getAllCFGs() {
        Collection<CFG> all = super.getAllCFGs();
        this.units.values().stream().flatMap(u -> u.getAllCFGs().stream()).forEach(all::add);
        return all;
    }

    @Override
    public Collection<NativeCFG> getAllConstructs() {
        Collection<NativeCFG> all = super.getAllConstructs();
        this.units.values().stream().flatMap(u -> u.getAllConstructs().stream()).forEach(all::add);
        return all;
    }

    @Override
    public Collection<Global> getAllGlobals() {
        Collection<Global> all = super.getAllGlobals();
        this.units.values().stream().flatMap(u -> u.getAllGlobals().stream()).forEach(all::add);
        return all;
    }

    @Override
    public final void validateAndFinalize() throws ProgramValidationException {
        this.types = null;
        super.validateAndFinalize();
        for (CompilationUnit unit : this.getUnits()) {
            unit.validateAndFinalize();
        }
    }
}

