/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program;

import it.unive.lisa.program.Global;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CFGDescriptor;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.NativeCFG;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class Unit {
    private final String name;
    private final Map<String, Global> globals;
    private final Map<String, CFG> cfgs;
    private final Map<String, NativeCFG> constructs;

    protected Unit(String name) {
        this.name = name;
        this.globals = new ConcurrentHashMap<String, Global>();
        this.cfgs = new ConcurrentHashMap<String, CFG>();
        this.constructs = new ConcurrentHashMap<String, NativeCFG>();
    }

    public final String getName() {
        return this.name;
    }

    public final Collection<Global> getGlobals() {
        return this.globals.values();
    }

    public final Collection<CFG> getCFGs() {
        return this.cfgs.values();
    }

    public final Collection<NativeCFG> getConstructs() {
        return this.constructs.values();
    }

    public final Collection<CodeMember> getCodeMembers() {
        HashSet<CodeMember> all = new HashSet<CodeMember>(this.getCFGs());
        all.addAll(this.getConstructs());
        return all;
    }

    public final Global getGlobal(String name) {
        return this.globals.get(name);
    }

    public final CFG getCFG(String signature) {
        return this.cfgs.get(signature);
    }

    public final NativeCFG getConstruct(String signature) {
        return this.constructs.get(signature);
    }

    public final CodeMember getCodeMember(String signature) {
        CFG res = this.getCFG(signature);
        if (res != null) {
            return res;
        }
        return this.getConstruct(signature);
    }

    public final Collection<CFG> getCFGsByName(String name) {
        return this.cfgs.values().stream().filter(c -> c.getDescriptor().getName().equals(name)).collect(Collectors.toList());
    }

    public final Collection<NativeCFG> getConstructsByName(String name) {
        return this.constructs.values().stream().filter(c -> c.getDescriptor().getName().equals(name)).collect(Collectors.toList());
    }

    public final Collection<CodeMember> getCodeMembersByName(String name) {
        HashSet<CodeMember> all = new HashSet<CodeMember>(this.getCFGsByName(name));
        all.addAll(this.getConstructsByName(name));
        return all;
    }

    public Collection<Global> getAllGlobals() {
        return new HashSet<Global>(this.getGlobals());
    }

    public Collection<CFG> getAllCFGs() {
        return new HashSet<CFG>(this.getCFGs());
    }

    public Collection<NativeCFG> getAllConstructs() {
        return new HashSet<NativeCFG>(this.getConstructs());
    }

    public final Collection<CodeMember> getAllCodeMembers() {
        HashSet<CodeMember> all = new HashSet<CodeMember>(this.getAllCFGs());
        all.addAll(this.getAllConstructs());
        return all;
    }

    public final boolean addGlobal(Global global) {
        return this.globals.putIfAbsent(global.getName(), global) == null;
    }

    public final boolean addCFG(CFG cfg) {
        return this.cfgs.putIfAbsent(cfg.getDescriptor().getSignature(), cfg) == null;
    }

    public final boolean addConstruct(NativeCFG construct) {
        return this.constructs.putIfAbsent(construct.getDescriptor().getSignature(), construct) == null;
    }

    public final String toString() {
        return this.name;
    }

    public final Collection<CodeMember> getMatchingCodeMember(CFGDescriptor signature) {
        HashSet<CodeMember> result = new HashSet<CodeMember>();
        for (CFG cfg : this.cfgs.values()) {
            if (!cfg.getDescriptor().matchesSignature(signature)) continue;
            result.add(cfg);
        }
        for (NativeCFG construct : this.constructs.values()) {
            if (!construct.getDescriptor().matchesSignature(signature)) continue;
            result.add(construct);
        }
        return result;
    }

    public void validateAndFinalize() throws ProgramValidationException {
        for (CodeMember codeMember : this.getCodeMembers()) {
            Collection<CodeMember> matching = this.getMatchingCodeMember(codeMember.getDescriptor());
            if (matching.size() == 1 && matching.iterator().next() == codeMember) continue;
            throw new ProgramValidationException(codeMember.getDescriptor().getSignature() + " is duplicated within unit " + this);
        }
        for (CFG cFG : this.getAllCFGs()) {
            cFG.validate();
        }
    }
}

