/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.annotations;

import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.matcher.AnnotationMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Annotations
implements Iterable<Annotation> {
    private final Collection<Annotation> annotations;

    public Annotations() {
        this(new ArrayList<Annotation>());
    }

    public Annotations(Annotation annotation) {
        this(List.of(annotation));
    }

    public Annotations(Annotation ... annotations) {
        this(List.of(annotations));
    }

    public Annotations(Collection<Annotation> annotations) {
        this.annotations = annotations;
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Iterator<Annotation> iterator() {
        return this.annotations.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotations other = (Annotations)obj;
        return !(this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations));
    }

    public String toString() {
        return this.annotations == null ? "[]" : "[" + StringUtils.join(this.annotations, (String)", ") + "]";
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.add(ann);
    }

    public final boolean contains(AnnotationMatcher m) {
        return this.annotations.stream().anyMatch(m::matches);
    }

    public final Annotations getAnnotations(AnnotationMatcher m) {
        return new Annotations(this.annotations.stream().filter(m::matches).collect(Collectors.toList()));
    }

    public final boolean isEmpty() {
        return this.annotations.isEmpty();
    }
}

