/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.CFGWithAnalysisResults;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.outputs.DotCFG;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.cfg.CFGDescriptor;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.VariableTableEntry;
import it.unive.lisa.program.cfg.controlFlow.ControlFlowExtractor;
import it.unive.lisa.program.cfg.controlFlow.ControlFlowStructure;
import it.unive.lisa.program.cfg.controlFlow.IfThenElse;
import it.unive.lisa.program.cfg.controlFlow.Loop;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NoOp;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.AdjacencyMatrix;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.algorithms.Fixpoint;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CFG
extends Graph<CFG, Statement, Edge>
implements CodeMember {
    private static final Logger LOG = LogManager.getLogger(CFG.class);
    private final CFGDescriptor descriptor;
    private final Collection<ControlFlowStructure> cfStructs;
    private boolean cfsExtracted;

    public CFG(CFGDescriptor descriptor) {
        this.descriptor = descriptor;
        this.cfStructs = new LinkedList<ControlFlowStructure>();
        this.cfsExtracted = false;
    }

    public CFG(CFGDescriptor descriptor, Collection<Statement> entrypoints, AdjacencyMatrix<Statement, Edge, CFG> adjacencyMatrix) {
        super(entrypoints, adjacencyMatrix);
        this.descriptor = descriptor;
        this.cfStructs = new LinkedList<ControlFlowStructure>();
        this.cfsExtracted = false;
    }

    protected CFG(CFG other) {
        super(other.entrypoints, other.adjacencyMatrix);
        this.descriptor = other.descriptor;
        this.cfStructs = other.cfStructs;
        this.cfsExtracted = other.cfsExtracted;
    }

    @Override
    public final CFGDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final Collection<Statement> getNormalExitpoints() {
        return this.adjacencyMatrix.getNodes().stream().filter(st -> st.stopsExecution() && !st.throwsError()).collect(Collectors.toList());
    }

    public final Collection<Statement> getAllExitpoints() {
        return this.adjacencyMatrix.getNodes().stream().filter(st -> st.stopsExecution() || st.throwsError()).collect(Collectors.toList());
    }

    public final void addControlFlowStructure(ControlFlowStructure cf) {
        if (this.cfStructs.stream().anyMatch(c -> c.getCondition().equals(cf.getCondition()))) {
            throw new IllegalArgumentException("Cannot have more than one conditional structure happening on the same condition: " + cf.getCondition());
        }
        this.cfStructs.add(cf);
    }

    public Collection<ControlFlowStructure> getControlFlowStructures() {
        if (this.cfStructs.isEmpty() && !this.cfsExtracted) {
            new ControlFlowExtractor(this).extract().forEach(this.cfStructs::add);
            this.cfsExtracted = true;
        }
        return this.cfStructs;
    }

    @Override
    public String toString() {
        return this.descriptor.toString();
    }

    public void simplify() {
        super.simplify(NoOp.class, new LinkedList(), new HashMap());
        this.cfStructs.forEach(ControlFlowStructure::simplify);
    }

    public final <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> CFGWithAnalysisResults<A, H, V> fixpoint(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, WorkingSet<Statement> ws, int widenAfter) throws FixpointException {
        HashMap start = new HashMap();
        this.entrypoints.forEach(e -> start.put((Statement)e, entryState));
        return this.fixpoint(entryState, start, interprocedural, ws, widenAfter);
    }

    public final <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> CFGWithAnalysisResults<A, H, V> fixpoint(Collection<Statement> entrypoints, AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, WorkingSet<Statement> ws, int widenAfter) throws FixpointException {
        HashMap start = new HashMap();
        entrypoints.forEach(e -> start.put((Statement)e, entryState));
        return this.fixpoint(entryState, start, interprocedural, ws, widenAfter);
    }

    public final <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> CFGWithAnalysisResults<A, H, V> fixpoint(AnalysisState<A, H, V> singleton, Map<Statement, AnalysisState<A, H, V>> startingPoints, InterproceduralAnalysis<A, H, V> interprocedural, WorkingSet<Statement> ws, int widenAfter) throws FixpointException {
        Fixpoint fix = new Fixpoint(this);
        HashMap starting = new HashMap();
        startingPoints.forEach((st, state) -> starting.put(st, Pair.of((Object)state, new StatementStore(state.bottom()))));
        Map fixpoint = fix.fixpoint(starting, ws, new CFGFixpoint<A, H, V>(widenAfter, interprocedural));
        HashMap finalResults = new HashMap(fixpoint.size());
        for (Map.Entry e : fixpoint.entrySet()) {
            finalResults.put(e.getKey(), (AnalysisState)((Pair)e.getValue()).getLeft());
            for (Map.Entry ee : (StatementStore)((Pair)e.getValue()).getRight()) {
                finalResults.put((Statement)ee.getKey(), (AnalysisState)ee.getValue());
            }
        }
        return new CFGWithAnalysisResults<A, H, V>(this, singleton, startingPoints, finalResults);
    }

    protected DotCFG toDot(Function<Statement, String> labelGenerator) {
        return DotCFG.fromCFG(this, null, labelGenerator);
    }

    @Override
    protected void preSimplify(Statement node) {
        this.shiftVariableScopes(node);
        this.shiftControlFlowStructuresEnd(node);
    }

    private void shiftControlFlowStructuresEnd(Statement node) {
        Collection<Statement> followers = this.followersOf(node);
        for (ControlFlowStructure cfs : this.cfStructs) {
            if (node != cfs.getFirstFollower()) continue;
            if (followers.isEmpty()) {
                cfs.setFirstFollower(null);
                continue;
            }
            if (followers.size() == 1) {
                Statement candidate = followers.iterator().next();
                if (!(candidate instanceof NoOp)) {
                    cfs.setFirstFollower(candidate);
                    continue;
                }
                cfs.setFirstFollower(this.firstNonNoOpDeterministicFollower(candidate));
                continue;
            }
            LOG.warn("{} is the first follower of a control flow structure, it is being simplified but has multiple followers: the first follower of the conditional structure will be lost", (Object)node);
            cfs.setFirstFollower(null);
        }
    }

    private Statement firstNonNoOpDeterministicFollower(Statement st) {
        Statement current = st;
        while (current instanceof NoOp) {
            Collection<Statement> followers = this.followersOf(current);
            if (followers.isEmpty() || followers.size() > 1) {
                return null;
            }
            current = followers.iterator().next();
        }
        return current;
    }

    private void shiftVariableScopes(Statement node) {
        Statement pred;
        Statement follow;
        Collection starting = this.descriptor.getVariables().stream().filter(v -> v.getScopeStart() == node).collect(Collectors.toList());
        Collection ending = this.descriptor.getVariables().stream().filter(v -> v.getScopeEnd() == node).collect(Collectors.toList());
        if (ending.isEmpty() && starting.isEmpty()) {
            return;
        }
        Collection<Statement> predecessors = this.predecessorsOf(node);
        Collection<Statement> followers = this.followersOf(node);
        if (predecessors.isEmpty() && followers.isEmpty()) {
            LOG.warn("Simplifying the only statement of '{}': all variables will be made visible for the entire cfg", (Object)this);
            starting.forEach(v -> v.setScopeStart(null));
            ending.forEach(v -> v.setScopeEnd(null));
            return;
        }
        String format = "Simplifying the scope-{} statement of a variable with {} is not supported: {} will be made visible {} of '" + this + "'";
        if (!starting.isEmpty()) {
            if (predecessors.isEmpty()) {
                if (followers.size() > 1) {
                    LOG.warn(format, (Object)"starting", (Object)"no predecessors and multiple followers", (Object)starting, (Object)"from the start");
                    follow = null;
                } else {
                    follow = followers.iterator().next();
                }
                starting.forEach(v -> v.setScopeStart(follow));
            } else {
                if (predecessors.size() > 1) {
                    LOG.warn(format, (Object)"starting", (Object)"multiple predecessors", (Object)starting, (Object)"from the start");
                    pred = null;
                } else {
                    pred = predecessors.iterator().next();
                }
                starting.forEach(v -> v.setScopeStart(pred));
            }
        }
        if (!ending.isEmpty()) {
            if (followers.isEmpty()) {
                if (predecessors.size() > 1) {
                    LOG.warn(format, (Object)"ending", (Object)"no followers and multiple predecessors", (Object)ending, (Object)"until the end");
                    pred = null;
                } else {
                    pred = predecessors.iterator().next();
                }
                ending.forEach(v -> v.setScopeEnd(pred));
            } else {
                if (followers.size() > 1) {
                    LOG.warn(format, (Object)"ending", (Object)"multiple followers", (Object)ending, (Object)"until the end");
                    follow = null;
                } else {
                    follow = followers.iterator().next();
                }
                ending.forEach(v -> v.setScopeEnd(follow));
            }
        }
    }

    public ProgramPoint getGenericProgramPoint() {
        return new ProgramPoint(){

            @Override
            public CFG getCFG() {
                return CFG.this;
            }

            public String toString() {
                return "unknown program point in " + CFG.this.getDescriptor().getSignature();
            }

            @Override
            public CodeLocation getLocation() {
                return null;
            }
        };
    }

    public void validate() throws ProgramValidationException {
        try {
            this.adjacencyMatrix.validate(this.entrypoints);
        }
        catch (ProgramValidationException e) {
            throw new ProgramValidationException("The matrix behind " + this + " is invalid", e);
        }
        for (ControlFlowStructure struct : this.cfStructs) {
            for (Statement st : struct.allStatements()) {
                if ((st != null || struct.getFirstFollower() == null) && (st == null || this.adjacencyMatrix.containsNode(st))) continue;
                throw new ProgramValidationException(this + " has a conditional structure (" + struct + ") that contains a node not in the graph: " + st);
            }
        }
        for (Map.Entry st : this.adjacencyMatrix) {
            if (!((Statement)st.getKey()).stopsExecution() || ((AdjacencyMatrix.NodeEdges)st.getValue()).getOutgoing().isEmpty()) continue;
            throw new ProgramValidationException(this + " contains an execution-stopping node that has followers: " + st.getKey());
        }
        if (!this.adjacencyMatrix.getNodes().containsAll(this.entrypoints)) {
            throw new ProgramValidationException(this + " has entrypoints that are not part of the graph: " + new HashSet(this.entrypoints).retainAll(this.adjacencyMatrix.getNodes()));
        }
    }

    private Collection<ControlFlowStructure> getControlFlowsContaining(ProgramPoint pp) {
        if (this.cfStructs.isEmpty() && !this.cfsExtracted) {
            new ControlFlowExtractor(this).extract().forEach(this.cfStructs::add);
            this.cfsExtracted = true;
        }
        if (!(pp instanceof Statement)) {
            return Collections.emptyList();
        }
        Statement st = (Statement)pp;
        if (st instanceof Expression) {
            st = ((Expression)st).getRootStatement();
        }
        LinkedList<ControlFlowStructure> res = new LinkedList<ControlFlowStructure>();
        for (ControlFlowStructure cf : this.cfStructs) {
            if (!cf.contains(st)) continue;
            res.add(cf);
        }
        return res;
    }

    public boolean isGuarded(ProgramPoint pp) {
        return !this.getControlFlowsContaining(pp).isEmpty();
    }

    public boolean isInsideLoop(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().anyMatch(Loop.class::isInstance);
    }

    public boolean isInsideIfThenElse(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().anyMatch(IfThenElse.class::isInstance);
    }

    public Collection<Statement> getGuards(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().map(ControlFlowStructure::getCondition).collect(Collectors.toList());
    }

    public Collection<Statement> getLoopGuards(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().filter(Loop.class::isInstance).map(ControlFlowStructure::getCondition).collect(Collectors.toList());
    }

    public Collection<Statement> getIfThenElseGuards(ProgramPoint pp) {
        return this.getControlFlowsContaining(pp).stream().filter(IfThenElse.class::isInstance).map(ControlFlowStructure::getCondition).collect(Collectors.toList());
    }

    private Statement getRecent(ProgramPoint pp, Predicate<ControlFlowStructure> filter) {
        if (!(pp instanceof Statement)) {
            return null;
        }
        Statement st = (Statement)pp;
        Collection<ControlFlowStructure> cfs = this.getControlFlowsContaining(pp);
        Statement recent = null;
        int min = Integer.MAX_VALUE;
        for (ControlFlowStructure cf : cfs) {
            if (!filter.test(cf)) continue;
            if (recent == null) {
                recent = cf.getCondition();
                min = cf.distance(st);
                continue;
            }
            int m = cf.distance(st);
            if (m >= min && min != -1) continue;
            recent = cf.getCondition();
            min = m;
        }
        if (min == -1) {
            throw new IllegalStateException("Conditional flow structures containing " + pp + " could not evaluate the distance from the root of the structure to the statement itself");
        }
        return recent;
    }

    public Statement getMostRecentGuard(ProgramPoint pp) {
        return this.getRecent(pp, cf -> true);
    }

    public Statement getMostRecentLoopGuard(ProgramPoint pp) {
        return this.getRecent(pp, Loop.class::isInstance);
    }

    public Statement getMostRecentIfThenElseGuard(ProgramPoint pp) {
        return this.getRecent(pp, IfThenElse.class::isInstance);
    }

    private final class CFGFixpoint<A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>>
    implements Fixpoint.FixpointImplementation<Statement, Edge, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>>> {
        private final InterproceduralAnalysis<A, H, V> interprocedural;
        private final int widenAfter;
        private final Map<Statement, Integer> lubs;

        private CFGFixpoint(int widenAfter, InterproceduralAnalysis<A, H, V> interprocedural) {
            this.widenAfter = widenAfter;
            this.interprocedural = interprocedural;
            this.lubs = new HashMap<Statement, Integer>(CFG.this.getNodesCount());
        }

        @Override
        public Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> semantics(Statement node, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> entrystate) throws SemanticException {
            StatementStore expressions = new StatementStore(((AnalysisState)entrystate.getLeft()).bottom());
            AnalysisState<A, H, V> approx = node.semantics((AnalysisState)entrystate.getLeft(), this.interprocedural, expressions);
            return Pair.of(approx, expressions);
        }

        @Override
        public Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> traverse(Edge edge, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> entrystate) throws SemanticException {
            AnalysisState approx = edge.traverse((AnalysisState)entrystate.getLeft());
            LinkedList<VariableTableEntry> toRemove = new LinkedList<VariableTableEntry>();
            for (VariableTableEntry entry : CFG.this.descriptor.getVariables()) {
                if (entry.getScopeEnd() != edge.getSource()) continue;
                toRemove.add(entry);
            }
            LinkedList<Identifier> ids = new LinkedList<Identifier>();
            for (VariableTableEntry entry : toRemove) {
                Variable v = entry.createReference(CFG.this).getVariable();
                for (SymbolicExpression expr : ((AnalysisState)approx.smallStepSemantics(v, (ProgramPoint)edge.getSource())).getComputedExpressions()) {
                    ids.add((Identifier)expr);
                }
            }
            if (!ids.isEmpty()) {
                approx = (AnalysisState)approx.forgetIdentifiers(ids);
            }
            return Pair.of((Object)approx, new StatementStore(approx.bottom()));
        }

        @Override
        public Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> union(Statement node, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> left, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> right) throws SemanticException {
            return Pair.of((Object)((AnalysisState)left.getLeft()).lub((AnalysisState)right.getLeft()), (Object)((StatementStore)left.getRight()).lub((StatementStore)right.getRight()));
        }

        @Override
        public Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> join(Statement node, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> approx, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> old) throws SemanticException {
            AnalysisState newApprox = (AnalysisState)approx.getLeft();
            AnalysisState oldApprox = (AnalysisState)old.getLeft();
            StatementStore newIntermediate = (StatementStore)approx.getRight();
            StatementStore oldIntermediate = (StatementStore)old.getRight();
            if (this.widenAfter == 0) {
                newApprox = newApprox.lub(oldApprox);
                newIntermediate = newIntermediate.lub(oldIntermediate);
            } else {
                int lub = this.lubs.computeIfAbsent(node, st -> this.widenAfter * CFG.this.predecessorsOf(st).size());
                if (lub > 0) {
                    newApprox = newApprox.lub(oldApprox);
                    newIntermediate = newIntermediate.lub(oldIntermediate);
                } else {
                    newApprox = oldApprox.widening(newApprox);
                    newIntermediate = oldIntermediate.widening(newIntermediate);
                }
                this.lubs.put(node, --lub);
            }
            return Pair.of((Object)newApprox, (Object)newIntermediate);
        }

        @Override
        public boolean equality(Statement node, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> approx, Pair<AnalysisState<A, H, V>, StatementStore<A, H, V>> old) throws SemanticException {
            return ((AnalysisState)approx.getLeft()).lessOrEqual((AnalysisState)old.getLeft()) && ((StatementStore)approx.getRight()).lessOrEqual((StatementStore)old.getRight());
        }
    }
}

