/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg;

import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.LiSAFactory;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.cfg.CFGDescriptor;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NativeCall;
import it.unive.lisa.program.cfg.statement.PluggableStatement;
import it.unive.lisa.program.cfg.statement.Statement;

public class NativeCFG
implements CodeMember {
    private final CFGDescriptor descriptor;
    private final Class<? extends NativeCall> construct;

    public NativeCFG(CFGDescriptor descriptor, Class<? extends NativeCall> construct) {
        if (!PluggableStatement.class.isAssignableFrom(construct)) {
            throw new IllegalArgumentException(construct + " must implement the " + PluggableStatement.class.getName() + " to be used within native cfgs");
        }
        this.descriptor = descriptor;
        this.construct = construct;
    }

    @Override
    public CFGDescriptor getDescriptor() {
        return this.descriptor;
    }

    public NativeCall rewrite(Statement original, Expression ... params) throws CallResolutionException {
        Object[] pars = new Object[params.length + 2];
        pars[0] = original.getCFG();
        pars[1] = original.getLocation();
        for (int i = 0; i < params.length; ++i) {
            pars[i + 2] = params[i];
        }
        try {
            NativeCall instance = LiSAFactory.getInstance(this.construct, pars);
            ((PluggableStatement)((Object)instance)).setOriginatingStatement(original);
            return instance;
        }
        catch (AnalysisSetupException e) {
            throw new CallResolutionException("Unable to create call to native construct " + this.construct.getName(), e);
        }
    }
}

