/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;

public class AccessInstanceGlobal
extends Expression {
    private final Expression receiver;
    private final Global target;

    public AccessInstanceGlobal(CFG cfg, CodeLocation location, Expression receiver, Global target) {
        super(cfg, location, target.getStaticType());
        this.receiver = receiver;
        this.target = target;
        receiver.setParentStatement(this);
    }

    @Override
    public int setOffset(int offset) {
        this.offset = offset;
        return this.offset;
    }

    @Override
    public <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        return visitor.visit(tool, this.getCFG(), (Edge)((Object)this));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.receiver == null ? 0 : this.receiver.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessInstanceGlobal other = (AccessInstanceGlobal)obj;
        if (this.receiver == null ? other.receiver != null : !this.receiver.equals(other.receiver)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    @Override
    public String toString() {
        return this.receiver + "::" + this.target.getName();
    }

    @Override
    public <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> semantics(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, StatementStore<A, H, V> expressions) throws SemanticException {
        AnalysisState<A, H, V> rec = this.receiver.semantics(entryState, interprocedural, expressions);
        expressions.put(this.receiver, rec);
        Lattice result = entryState.bottom();
        Variable v = new Variable(this.getRuntimeTypes(), this.target.getName(), this.target.getAnnotations(), this.target.getLocation());
        for (SymbolicExpression expr : rec.getComputedExpressions()) {
            SemanticDomain tmp = rec.smallStepSemantics(new AccessChild(this.getRuntimeTypes(), new HeapDereference(this.getRuntimeTypes(), expr, this.getLocation()), v, this.getLocation()), (ProgramPoint)this);
            result = (AnalysisState)((BaseLattice)result).lub(tmp);
        }
        if (!this.receiver.getMetaVariables().isEmpty()) {
            result = (AnalysisState)result.forgetIdentifiers(this.receiver.getMetaVariables());
        }
        return result;
    }
}

