/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.BinaryExpression;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.symbolic.SymbolicExpression;

public class Assignment
extends BinaryExpression {
    public Assignment(CFG cfg, CodeLocation location, Expression target, Expression expression) {
        super(cfg, location, target, expression);
    }

    @Override
    public final String toString() {
        return this.getLeft() + " = " + this.getRight();
    }

    @Override
    public final <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> semantics(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, StatementStore<A, H, V> expressions) throws SemanticException {
        AnalysisState<A, H, V> right = this.getRight().semantics(entryState, interprocedural, expressions);
        AnalysisState<A, H, V> left = this.getLeft().semantics(right, interprocedural, expressions);
        expressions.put(this.getRight(), right);
        expressions.put(this.getLeft(), left);
        AnalysisState<A, H, V> result = right.bottom();
        for (SymbolicExpression expr1 : left.getComputedExpressions()) {
            for (SymbolicExpression expr2 : right.getComputedExpressions()) {
                AnalysisState<A, H, V> tmp = left.assign(expr1, expr2, (ProgramPoint)this);
                result = result.lub(tmp);
            }
        }
        if (!this.getRight().getMetaVariables().isEmpty()) {
            result = (AnalysisState)result.forgetIdentifiers(this.getRight().getMetaVariables());
        }
        if (!this.getLeft().getMetaVariables().isEmpty()) {
            result = (AnalysisState)result.forgetIdentifiers(this.getLeft().getMetaVariables());
        }
        return result;
    }
}

