/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import java.util.Objects;

public abstract class BinaryExpression
extends Expression {
    private final Expression left;
    private final Expression right;

    protected BinaryExpression(CFG cfg, CodeLocation location, Expression left, Expression right) {
        super(cfg, location);
        Objects.requireNonNull(left, "The left-handside of a binary expression cannot be null");
        Objects.requireNonNull(right, "The right-handside of a binary expression cannot be null");
        this.left = left;
        this.right = right;
        left.setParentStatement(this);
        right.setParentStatement(this);
    }

    public final Expression getLeft() {
        return this.left;
    }

    public final Expression getRight() {
        return this.right;
    }

    @Override
    public final int setOffset(int offset) {
        this.offset = offset;
        return this.right.setOffset(this.left.setOffset(offset + 1) + 1);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryExpression other = (BinaryExpression)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    @Override
    public final <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        if (!this.left.accept(visitor, tool)) {
            return false;
        }
        if (!this.right.accept(visitor, tool)) {
            return false;
        }
        return visitor.visit(tool, this.getCFG(), (Edge)((Object)this));
    }
}

