/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.Call;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.MetaVariableCreator;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CFGCall
extends Call
implements MetaVariableCreator {
    private final Collection<CFG> targets;
    private final String qualifiedName;

    public CFGCall(CFG cfg, CodeLocation location, String qualifiedName, CFG target, Expression ... parameters) {
        this(cfg, location, qualifiedName, Collections.singleton(target), parameters);
    }

    public CFGCall(CFG cfg, CodeLocation location, String qualifiedName, Collection<CFG> targets, Expression ... parameters) {
        super(cfg, location, CFGCall.getCommonReturnType(targets), parameters);
        Objects.requireNonNull(qualifiedName, "The qualified name of the static target of a CFG call cannot be null");
        Objects.requireNonNull(targets, "The targets of a CFG call cannot be null");
        for (CFG target : targets) {
            Objects.requireNonNull(target, "A target of a CFG call cannot be null");
        }
        this.targets = targets;
        this.qualifiedName = qualifiedName;
    }

    private static Type getCommonReturnType(Collection<CFG> targets) {
        Iterator<CFG> it = targets.iterator();
        Type result = null;
        while (it.hasNext()) {
            Type current = it.next().getDescriptor().getReturnType();
            if (result == null) {
                result = current;
            } else {
                if (current.canBeAssignedTo(result)) continue;
                result = result.canBeAssignedTo(current) ? current : result.commonSupertype(current);
            }
            if (!current.isUntyped()) continue;
            break;
        }
        return result == null ? Untyped.INSTANCE : result;
    }

    public Collection<CFG> getTargets() {
        return this.targets;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.qualifiedName == null ? 0 : this.qualifiedName.hashCode());
        result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CFGCall other = (CFGCall)obj;
        if (this.qualifiedName == null ? other.qualifiedName != null : !this.qualifiedName.equals(other.qualifiedName)) {
            return false;
        }
        return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
    }

    @Override
    public String toString() {
        return "[" + this.targets.size() + " targets]" + this.qualifiedName + "(" + StringUtils.join((Object[])this.getParameters(), (String)", ") + ")";
    }

    @Override
    public final Identifier getMetaVariable() {
        return new Variable(this.getRuntimeTypes(), "call_ret_value@" + this.getLocation(), this.getLocation());
    }

    @Override
    public <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> callSemantics(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, AnalysisState<A, H, V>[] computedStates, ExpressionSet<SymbolicExpression>[] params) throws SemanticException {
        AnalysisState<A, H, V> callState = computedStates.length == 0 ? entryState : computedStates[computedStates.length - 1];
        callState = new AnalysisState(callState.getState(), new ExpressionSet<SymbolicExpression>());
        AnalysisState<A, H, V> returned = interprocedural.getAbstractResultOf(this, callState, params);
        if (this.getStaticType().isVoidType() || this.getStaticType().isUntyped() && returned.getComputedExpressions().isEmpty() || returned.getComputedExpressions().size() == 1 && returned.getComputedExpressions().iterator().next() instanceof Skip) {
            return returned.smallStepSemantics(new Skip(this.getLocation()), (ProgramPoint)this);
        }
        Identifier meta = this.getMetaVariable();
        for (SymbolicExpression expr : returned.getComputedExpressions()) {
            this.getMetaVariables().add((Identifier)expr);
        }
        for (CFG target : this.targets) {
            for (Annotation ann : target.getDescriptor().getAnnotations()) {
                meta.addAnnotation(ann);
            }
        }
        this.getMetaVariables().add(meta);
        Lattice result = returned.bottom();
        for (SymbolicExpression expr : returned.getComputedExpressions()) {
            SemanticDomain tmp = returned.assign(meta, expr, (ProgramPoint)this);
            result = (AnalysisState)((BaseLattice)result).lub(((AnalysisState)tmp).smallStepSemantics(meta, (ProgramPoint)this));
        }
        return result;
    }
}

