/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import java.util.Arrays;
import java.util.Objects;

public abstract class Call
extends Expression {
    private final Expression[] parameters;

    protected Call(CFG cfg, CodeLocation location, Type staticType, Expression ... parameters) {
        super(cfg, location, staticType);
        Objects.requireNonNull(parameters, "The array of parameters of a call cannot be null");
        for (int i = 0; i < parameters.length; ++i) {
            Objects.requireNonNull(parameters[i], "The " + i + "-th parameter of a call cannot be null");
        }
        this.parameters = parameters;
        for (Expression param : parameters) {
            param.setParentStatement(this);
        }
    }

    public final Expression[] getParameters() {
        return this.parameters;
    }

    @Override
    public final int setOffset(int offset) {
        this.offset = offset;
        int off = offset;
        for (Expression param : this.parameters) {
            off = param.setOffset(off + 1);
        }
        return off;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Call other = (Call)obj;
        return Arrays.equals(this.parameters, other.parameters);
    }

    @Override
    public final <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> semantics(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, StatementStore<A, H, V> expressions) throws SemanticException {
        ExpressionSet[] computed = new ExpressionSet[this.parameters.length];
        AnalysisState[] paramStates = new AnalysisState[this.parameters.length];
        AnalysisState<A, H, V> preState = entryState;
        for (int i = 0; i < computed.length; ++i) {
            paramStates[i] = this.parameters[i].semantics(preState, interprocedural, expressions);
            preState = paramStates[i];
            expressions.put(this.parameters[i], paramStates[i]);
            computed[i] = paramStates[i].getComputedExpressions();
        }
        AnalysisState result = this.callSemantics(entryState, interprocedural, paramStates, computed);
        for (Expression param : this.parameters) {
            if (param.getMetaVariables().isEmpty()) continue;
            result = (AnalysisState)result.forgetIdentifiers(param.getMetaVariables());
        }
        return result;
    }

    public abstract <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> callSemantics(AnalysisState<A, H, V> var1, InterproceduralAnalysis<A, H, V> var2, AnalysisState<A, H, V>[] var3, ExpressionSet<SymbolicExpression>[] var4) throws SemanticException;

    @Override
    public <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        for (Expression par : this.parameters) {
            if (par.accept(visitor, tool)) continue;
            return false;
        }
        return visitor.visit(tool, this.getCFG(), (Edge)((Object)this));
    }
}

