/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.caches.Caches;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public abstract class Expression
extends Statement {
    private final Type staticType;
    private ExternalSet<Type> runtimeTypes;
    private Statement parent;
    private final Collection<Identifier> metaVariables;

    protected Expression(CFG cfg, CodeLocation location) {
        this(cfg, location, Untyped.INSTANCE);
    }

    protected Expression(CFG cfg, CodeLocation location, Type staticType) {
        super(cfg, location);
        Objects.requireNonNull(staticType, "The expression type of a CFG cannot be null");
        this.staticType = staticType;
        this.metaVariables = new HashSet<Identifier>();
    }

    public final Type getStaticType() {
        return this.staticType;
    }

    public final void setRuntimeTypes(ExternalSet<Type> runtimeTypes) {
        if (runtimeTypes == null) {
            return;
        }
        if (this.runtimeTypes != null && (this.runtimeTypes == runtimeTypes || this.runtimeTypes.equals(runtimeTypes))) {
            return;
        }
        if (this.runtimeTypes != null && runtimeTypes.isEmpty()) {
            this.runtimeTypes.clear();
        } else {
            this.runtimeTypes = runtimeTypes.copy();
        }
    }

    public final ExternalSet<Type> getRuntimeTypes() {
        if (this.runtimeTypes == null) {
            return Caches.types().mkSet(this.staticType.allInstances());
        }
        return this.runtimeTypes;
    }

    public final Type getDynamicType() {
        ExternalSet<Type> runtimes = this.getRuntimeTypes();
        return this.getRuntimeTypes().reduce(runtimes.first(), (result, t) -> {
            if (result.canBeAssignedTo((Type)t)) {
                return t;
            }
            if (t.canBeAssignedTo((Type)result)) {
                return result;
            }
            return t.commonSupertype((Type)result);
        });
    }

    public Collection<Identifier> getMetaVariables() {
        return this.metaVariables;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.staticType == null ? 0 : this.staticType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        return !(this.staticType == null ? other.staticType != null : !this.staticType.equals(other.staticType));
    }

    public final void setParentStatement(Statement st) {
        this.parent = st;
    }

    public final Statement getParentStatement() {
        return this.parent;
    }

    public final Statement getRootStatement() {
        if (this.parent == null) {
            return this;
        }
        if (!(this.parent instanceof Expression)) {
            return this.parent;
        }
        return ((Expression)this.parent).getRootStatement();
    }
}

