/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.NativeCFG;
import it.unive.lisa.program.cfg.statement.CFGCall;
import it.unive.lisa.program.cfg.statement.Call;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NativeCall;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class HybridCall
extends Call {
    private final Collection<CFG> targets;
    private final Collection<NativeCFG> nativeTargets;
    private final String qualifiedName;

    public HybridCall(CFG cfg, CodeLocation location, String qualifiedName, Collection<CFG> targets, Collection<NativeCFG> nativeTargets, Expression ... parameters) {
        super(cfg, location, HybridCall.getCommonReturnType(targets), parameters);
        Objects.requireNonNull(qualifiedName, "The qualified name of the static target of a CFG call cannot be null");
        Objects.requireNonNull(targets, "The targets of a CFG call cannot be null");
        Objects.requireNonNull(nativeTargets, "The native targets of a CFG call cannot be null");
        for (CFG target : targets) {
            Objects.requireNonNull(target, "A target of a CFG call cannot be null");
        }
        this.targets = targets;
        this.nativeTargets = nativeTargets;
        this.qualifiedName = qualifiedName;
    }

    private static Type getCommonReturnType(Collection<CFG> targets) {
        Iterator<CFG> it = targets.iterator();
        Type result = null;
        while (it.hasNext()) {
            Type current = it.next().getDescriptor().getReturnType();
            if (result == null) {
                result = current;
            } else {
                if (current.canBeAssignedTo(result)) continue;
                result = result.canBeAssignedTo(current) ? current : result.commonSupertype(current);
            }
            if (!current.isUntyped()) continue;
            break;
        }
        return result == null ? Untyped.INSTANCE : result;
    }

    public Collection<CFG> getTargets() {
        return this.targets;
    }

    public Collection<NativeCFG> getNativeTargets() {
        return this.nativeTargets;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nativeTargets == null ? 0 : this.nativeTargets.hashCode());
        result = 31 * result + (this.qualifiedName == null ? 0 : this.qualifiedName.hashCode());
        result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HybridCall other = (HybridCall)obj;
        if (this.nativeTargets == null ? other.nativeTargets != null : !this.nativeTargets.equals(other.nativeTargets)) {
            return false;
        }
        if (this.qualifiedName == null ? other.qualifiedName != null : !this.qualifiedName.equals(other.qualifiedName)) {
            return false;
        }
        return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
    }

    @Override
    public String toString() {
        return "[" + this.targets.size() + this.nativeTargets.size() + " targets]" + this.qualifiedName + "(" + StringUtils.join((Object[])this.getParameters(), (String)", ") + ")";
    }

    @Override
    public <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> callSemantics(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, AnalysisState<A, H, V>[] computedStates, ExpressionSet<SymbolicExpression>[] params) throws SemanticException {
        AnalysisState<A, H, V> result = entryState.bottom();
        if (!this.targets.isEmpty()) {
            CFGCall cfgcall = new CFGCall(this.getCFG(), this.getLocation(), this.qualifiedName, this.getTargets(), this.getParameters());
            cfgcall.setRuntimeTypes(this.getRuntimeTypes());
            result = cfgcall.callSemantics(entryState, interprocedural, computedStates, params);
            this.getMetaVariables().addAll(cfgcall.getMetaVariables());
        }
        for (NativeCFG nat : this.nativeTargets) {
            try {
                NativeCall rewritten = nat.rewrite(this, this.getParameters());
                result = result.lub(rewritten.callSemantics(entryState, interprocedural, computedStates, params));
                this.getMetaVariables().addAll(rewritten.getMetaVariables());
            }
            catch (CallResolutionException e) {
                throw new SemanticException("Unable to resolve call " + this, e);
            }
        }
        return result;
    }
}

