/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Call;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class NativeCall
extends Call {
    private final String constructName;

    protected NativeCall(CFG cfg, CodeLocation location, String constructName, Expression ... parameters) {
        this(cfg, location, constructName, Untyped.INSTANCE, parameters);
    }

    protected NativeCall(CFG cfg, CodeLocation location, String constructName, Type staticType, Expression ... parameters) {
        super(cfg, location, staticType, parameters);
        Objects.requireNonNull(constructName, "The name of the native construct of a native call cannot be null");
        this.constructName = constructName;
    }

    public final String getConstructName() {
        return this.constructName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.constructName == null ? 0 : this.constructName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NativeCall other = (NativeCall)obj;
        return !(this.constructName == null ? other.constructName != null : !this.constructName.equals(other.constructName));
    }

    @Override
    public final String toString() {
        return this.constructName + "(" + StringUtils.join((Object[])this.getParameters(), (String)", ") + ")";
    }
}

