/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.statement.Call;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.MetaVariableCreator;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OpenCall
extends Call
implements MetaVariableCreator {
    private final String targetName;

    public OpenCall(CFG cfg, CodeLocation location, String targetName, Type staticType, Expression ... parameters) {
        super(cfg, location, staticType, parameters);
        Objects.requireNonNull(targetName, "The name of the target of an open call cannot be null");
        this.targetName = targetName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.targetName == null ? 0 : this.targetName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenCall other = (OpenCall)obj;
        return !(this.targetName == null ? other.targetName != null : !this.targetName.equals(other.targetName));
    }

    @Override
    public String toString() {
        return "[open call]" + this.targetName + "(" + StringUtils.join((Object[])this.getParameters(), (String)", ") + ")";
    }

    @Override
    public final Identifier getMetaVariable() {
        return new Variable(this.getRuntimeTypes(), "open_call_ret_value@" + this.getLocation(), this.getLocation());
    }

    @Override
    public <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> callSemantics(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, AnalysisState<A, H, V>[] computedStates, ExpressionSet<SymbolicExpression>[] params) throws SemanticException {
        Lattice poststate = entryState.top();
        if (this.getStaticType().isVoidType()) {
            return ((AnalysisState)poststate).smallStepSemantics(new Skip(this.getLocation()), (ProgramPoint)this);
        }
        return ((AnalysisState)poststate).smallStepSemantics(this.getMetaVariable(), (ProgramPoint)this);
    }
}

