/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import java.util.Objects;

public abstract class UnaryStatement
extends Statement {
    private final Expression expression;

    protected UnaryStatement(CFG cfg, CodeLocation location, Expression expression) {
        super(cfg, location);
        Objects.requireNonNull(expression, "The argument of a unary statement cannot be null");
        this.expression = expression;
        expression.setParentStatement(this);
    }

    public final Expression getExpression() {
        return this.expression;
    }

    @Override
    public final int setOffset(int offset) {
        this.offset = offset;
        return this.expression.setOffset(offset + 1);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryStatement other = (UnaryStatement)obj;
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }

    @Override
    public final <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        if (!this.expression.accept(visitor, tool)) {
            return false;
        }
        return visitor.visit(tool, this.getCFG(), (Edge)((Object)this));
    }
}

