/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.statement.Call;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Untyped;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class UnresolvedCall
extends Call {
    private final ResolutionStrategy strategy;
    private final String targetName;
    private final boolean instanceCall;

    public UnresolvedCall(CFG cfg, CodeLocation location, ResolutionStrategy strategy, boolean instanceCall, String targetName, Expression ... parameters) {
        super(cfg, location, Untyped.INSTANCE, parameters);
        Objects.requireNonNull(targetName, "The target's name of an unresolved call cannot be null");
        this.strategy = strategy;
        this.targetName = targetName;
        this.instanceCall = instanceCall;
    }

    public ResolutionStrategy getStrategy() {
        return this.strategy;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public boolean isInstanceCall() {
        return this.instanceCall;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.instanceCall ? 1231 : 1237);
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        result = 31 * result + (this.targetName == null ? 0 : this.targetName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnresolvedCall other = (UnresolvedCall)obj;
        if (this.instanceCall != other.instanceCall) {
            return false;
        }
        if (this.strategy != other.strategy) {
            return false;
        }
        return !(this.targetName == null ? other.targetName != null : !this.targetName.equals(other.targetName));
    }

    @Override
    public String toString() {
        return "[unresolved]" + this.targetName + "(" + StringUtils.join((Object[])this.getParameters(), (String)", ") + ")";
    }

    @Override
    public <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> callSemantics(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, AnalysisState<A, H, V>[] computedStates, ExpressionSet<SymbolicExpression>[] params) throws SemanticException {
        Call resolved;
        try {
            resolved = interprocedural.resolve(this);
        }
        catch (CallResolutionException e) {
            throw new SemanticException("Unable to resolve call " + this, e);
        }
        resolved.setRuntimeTypes(this.getRuntimeTypes());
        AnalysisState<A, H, V> result = resolved.callSemantics(entryState, interprocedural, computedStates, params);
        this.getMetaVariables().addAll(resolved.getMetaVariables());
        return result;
    }

    public void inheritRuntimeTypesFrom(Expression other) {
        this.setRuntimeTypes(other.getRuntimeTypes());
    }

    public static enum ResolutionStrategy {
        STATIC_TYPES{

            @Override
            protected boolean matches(int pos, Parameter formal, Expression actual) {
                return actual.getStaticType().canBeAssignedTo(formal.getStaticType());
            }
        }
        ,
        DYNAMIC_TYPES{

            @Override
            protected boolean matches(int pos, Parameter formal, Expression actual) {
                return actual.getRuntimeTypes().anyMatch(rt -> rt.canBeAssignedTo(formal.getStaticType()));
            }
        }
        ,
        FIRST_DYNAMIC_THEN_STATIC{

            @Override
            protected boolean matches(int pos, Parameter formal, Expression actual) {
                return pos == 0 ? DYNAMIC_TYPES.matches(pos, formal, actual) : STATIC_TYPES.matches(pos, formal, actual);
            }
        };


        public final boolean matches(Parameter[] formals, Expression[] actuals) {
            if (formals.length != actuals.length) {
                return false;
            }
            for (int i = 0; i < formals.length; ++i) {
                if (this.matches(i, formals[i], actuals[i])) continue;
                return false;
            }
            return true;
        }

        protected abstract boolean matches(int var1, Parameter var2, Expression var3);
    }
}

