/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.VariableTableEntry;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import java.util.Objects;

public class VariableRef
extends Expression {
    private final String name;

    public VariableRef(CFG cfg, CodeLocation location, String name) {
        this(cfg, location, name, Untyped.INSTANCE);
    }

    public VariableRef(CFG cfg, CodeLocation location, String name, Type type) {
        super(cfg, location, type);
        Objects.requireNonNull(name, "The name of a variable cannot be null");
        this.name = name;
    }

    @Override
    public int setOffset(int offset) {
        this.offset = offset;
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableRef other = (VariableRef)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String toString() {
        return this.name;
    }

    public Variable getVariable() {
        Variable v = new Variable(this.getRuntimeTypes(), this.getName(), this.getLocation());
        for (Annotation ann : this.getAnnotations()) {
            v.addAnnotation(ann);
        }
        return v;
    }

    @Override
    public <A extends AbstractState<A, H, V>, H extends HeapDomain<H>, V extends ValueDomain<V>> AnalysisState<A, H, V> semantics(AnalysisState<A, H, V> entryState, InterproceduralAnalysis<A, H, V> interprocedural, StatementStore<A, H, V> expressions) throws SemanticException {
        Variable expr = this.getVariable();
        return entryState.smallStepSemantics(expr, (ProgramPoint)this);
    }

    @Override
    public <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        return visitor.visit(tool, this.getCFG(), (Edge)((Object)this));
    }

    public Annotations getAnnotations() {
        for (VariableTableEntry entry : this.getCFG().getDescriptor().getVariables()) {
            if (!entry.getName().equals(this.getName())) continue;
            return entry.getAnnotations();
        }
        return new Annotations();
    }
}

