/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public abstract class SymbolicExpression {
    private final CodeLocation location;
    private final ExternalSet<Type> types;

    protected SymbolicExpression(ExternalSet<Type> types, CodeLocation location) {
        this.types = types;
        this.location = location;
    }

    public final ExternalSet<Type> getTypes() {
        return this.types;
    }

    public final Type getDynamicType() {
        return this.types.reduce(this.types.first(), (result, t) -> result.commonSupertype((Type)t));
    }

    public abstract SymbolicExpression pushScope(ScopeToken var1) throws SemanticException;

    public abstract SymbolicExpression popScope(ScopeToken var1) throws SemanticException;

    public abstract <T> T accept(ExpressionVisitor<T> var1, Object ... var2) throws SemanticException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolicExpression other = (SymbolicExpression)obj;
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }

    public CodeLocation getCodeLocation() {
        return this.location;
    }

    public abstract String toString();
}

