/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.heap;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public class AccessChild
extends HeapExpression {
    private final SymbolicExpression container;
    private final SymbolicExpression child;

    public AccessChild(ExternalSet<Type> types, SymbolicExpression container, SymbolicExpression child, CodeLocation location) {
        super(types, location);
        this.container = container;
        this.child = child;
    }

    public SymbolicExpression getContainer() {
        return this.container;
    }

    public SymbolicExpression getChild() {
        return this.child;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessChild other = (AccessChild)obj;
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        return !(this.child == null ? other.child != null : !this.child.equals(other.child));
    }

    @Override
    public String toString() {
        return this.container + "->" + this.child;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        T cont = this.container.accept(visitor, params);
        T ch = this.child.accept(visitor, params);
        return visitor.visit(this, cont, ch, params);
    }
}

