/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.BinaryOperator;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public class BinaryExpression
extends ValueExpression {
    private final SymbolicExpression left;
    private final SymbolicExpression right;
    private final BinaryOperator operator;

    public BinaryExpression(ExternalSet<Type> types, SymbolicExpression left, SymbolicExpression right, BinaryOperator operator, CodeLocation location) {
        super(types, location);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public SymbolicExpression getLeft() {
        return this.left;
    }

    public SymbolicExpression getRight() {
        return this.right;
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public SymbolicExpression pushScope(ScopeToken token) throws SemanticException {
        return new BinaryExpression(this.getTypes(), this.left.pushScope(token), this.right.pushScope(token), this.operator, this.getCodeLocation());
    }

    @Override
    public SymbolicExpression popScope(ScopeToken token) throws SemanticException {
        return new BinaryExpression(this.getTypes(), this.left.popScope(token), this.right.popScope(token), this.operator, this.getCodeLocation());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryExpression other = (BinaryExpression)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    @Override
    public String toString() {
        return this.left + " " + this.operator + " " + this.right;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        T left = this.left.accept(visitor, params);
        T right = this.right.accept(visitor, params);
        return visitor.visit(this, left, right, params);
    }
}

