/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value;

import it.unive.lisa.symbolic.value.Operator;

public enum BinaryOperator implements Operator
{
    NUMERIC_SUB("-"),
    NUMERIC_ADD("+"),
    NUMERIC_DIV("/"),
    NUMERIC_MUL("*"),
    NUMERIC_MOD("%"),
    LOGICAL_OR("||"){

        @Override
        public BinaryOperator opposite() {
            return LOGICAL_AND;
        }
    }
    ,
    LOGICAL_AND("&&"){

        @Override
        public BinaryOperator opposite() {
            return LOGICAL_OR;
        }
    }
    ,
    COMPARISON_NE("!="){

        @Override
        public BinaryOperator opposite() {
            return COMPARISON_EQ;
        }
    }
    ,
    COMPARISON_EQ("=="){

        @Override
        public BinaryOperator opposite() {
            return COMPARISON_NE;
        }
    }
    ,
    COMPARISON_GE(">="){

        @Override
        public BinaryOperator opposite() {
            return COMPARISON_LT;
        }
    }
    ,
    COMPARISON_GT(">"){

        @Override
        public BinaryOperator opposite() {
            return COMPARISON_LE;
        }
    }
    ,
    COMPARISON_LE("<="){

        @Override
        public BinaryOperator opposite() {
            return COMPARISON_GT;
        }
    }
    ,
    COMPARISON_LT("<"){

        @Override
        public BinaryOperator opposite() {
            return COMPARISON_GE;
        }
    }
    ,
    STRING_CONCAT("strcat"),
    STRING_CONTAINS("strcontains"),
    STRING_STARTS_WITH("strstarts"),
    STRING_ENDS_WITH("strends"),
    STRING_INDEX_OF("strindexof"),
    STRING_EQUALS("strcmp"),
    TYPE_CAST("cast-as"),
    TYPE_CONV("conv-as"),
    TYPE_CHECK("is");

    private final String representation;

    private BinaryOperator(String representation) {
        this.representation = representation;
    }

    @Override
    public String getStringRepresentation() {
        return this.representation;
    }

    public String toString() {
        return this.getStringRepresentation();
    }
}

