/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;

public class OutOfScopeIdentifier
extends Identifier {
    private final ScopeToken scope;
    private final Identifier id;

    public OutOfScopeIdentifier(Identifier id, ScopeToken scope, CodeLocation location) {
        super(id.getTypes(), scope.toString() + ":" + id.getName(), id.isWeak(), location);
        this.id = id;
        this.scope = scope;
    }

    @Override
    public SymbolicExpression pushScope(ScopeToken token) {
        return new OutOfScopeIdentifier(this, token, this.getCodeLocation());
    }

    @Override
    public Identifier popScope(ScopeToken token) throws SemanticException {
        if (this.getScope().equals(token)) {
            return this.id;
        }
        return null;
    }

    public ScopeToken getScope() {
        return this.scope;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        return visitor.visit(this, params);
    }
}

