/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.BinaryOperator;
import it.unive.lisa.symbolic.value.UnaryOperator;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.externalSet.ExternalSet;

public class UnaryExpression
extends ValueExpression {
    private final SymbolicExpression expression;
    private final UnaryOperator operator;

    public UnaryExpression(ExternalSet<Type> types, SymbolicExpression expression, UnaryOperator operator, CodeLocation location) {
        super(types, location);
        this.expression = expression;
        this.operator = operator;
    }

    public SymbolicExpression getExpression() {
        return this.expression;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public ValueExpression removeNegations() {
        if (this.operator == UnaryOperator.LOGICAL_NOT && this.expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)this.expression;
            ValueExpression left = (ValueExpression)binary.getLeft();
            ValueExpression right = (ValueExpression)binary.getRight();
            BinaryOperator op = binary.getOperator();
            return new BinaryExpression(binary.getTypes(), left.removeNegations(), right.removeNegations(), (BinaryOperator)op.opposite(), this.getCodeLocation());
        }
        return this;
    }

    @Override
    public SymbolicExpression pushScope(ScopeToken token) throws SemanticException {
        return new UnaryExpression(this.getTypes(), this.expression.pushScope(token), this.operator, this.getCodeLocation());
    }

    @Override
    public SymbolicExpression popScope(ScopeToken token) throws SemanticException {
        return new UnaryExpression(this.getTypes(), this.expression.popScope(token), this.operator, this.getCodeLocation());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryExpression other = (UnaryExpression)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return this.operator == other.operator;
    }

    @Override
    public String toString() {
        return this.operator.toString() + this.expression.toString();
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        T arg = this.expression.accept(visitor, params);
        return visitor.visit(this, arg, params);
    }
}

