/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IterableArray<E>
implements Iterable<E> {
    private final E[] array;

    public IterableArray(E[] array) {
        this.array = array;
    }

    public int size() {
        return this.array.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.array);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IterableArray other = (IterableArray)obj;
        return Arrays.deepEquals(this.array, other.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorFromArray();
    }

    private final class IteratorFromArray
    implements Iterator<E> {
        private int pos;

        private IteratorFromArray() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < IterableArray.this.array.length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("End of the array reached");
            }
            return IterableArray.this.array[this.pos++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from an iterator built over an array");
        }
    }
}

