/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections.externalSet;

import it.unive.lisa.util.collections.externalSet.ExternalSet;
import it.unive.lisa.util.collections.externalSet.ExternalSetCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;

public final class BitExternalSet<T>
implements ExternalSet<T> {
    private long[] bits;
    private final ExternalSetCache<T> cache;

    BitExternalSet(ExternalSetCache<T> cache) {
        this.bits = new long[1];
        this.cache = cache;
    }

    BitExternalSet(long[] bits, ExternalSetCache<T> cache) {
        this.bits = bits;
        this.cache = cache;
    }

    BitExternalSet(BitExternalSet<T> other) {
        this.bits = (long[])other.bits.clone();
        this.cache = other.cache;
    }

    BitExternalSet(ExternalSetCache<T> cache, T element) {
        this.cache = cache;
        int pos = cache.indexOfOrAdd(element);
        this.bits = new long[1 + BitExternalSet.bitvector_index(pos)];
        BitExternalSet.set(this.bits, pos);
    }

    BitExternalSet(ExternalSetCache<T> cache, Iterable<T> elements) {
        this(cache);
        for (T e : elements) {
            this.add(e);
        }
    }

    @Override
    public ExternalSetCache<T> getCache() {
        return this.cache;
    }

    private void expand(int targetLength) {
        long[] localbits = this.bits;
        this.bits = new long[targetLength];
        System.arraycopy(localbits, 0, this.bits, 0, localbits.length);
    }

    private void shrink(int targetLength) {
        long[] localbits = this.bits;
        this.bits = new long[targetLength];
        System.arraycopy(localbits, 0, this.bits, 0, targetLength);
    }

    @Override
    public boolean add(T e) {
        long[] localbits = this.bits;
        int pos = this.cache.indexOfOrAdd(e);
        int bitvector = BitExternalSet.bitvector_index(pos);
        if (bitvector >= localbits.length) {
            this.expand(1 + bitvector);
            BitExternalSet.set(this.bits, pos);
            return true;
        }
        if (BitExternalSet.isset(localbits, pos)) {
            return false;
        }
        BitExternalSet.set(localbits, pos);
        return true;
    }

    @Override
    public void addAll(ExternalSet<T> other) {
        if (this == other) {
            return;
        }
        if (other == null) {
            return;
        }
        if (this.cache != other.getCache()) {
            return;
        }
        if (!(other instanceof BitExternalSet)) {
            ExternalSet.super.addAll(other);
        } else {
            BitExternalSet o = (BitExternalSet)other;
            long[] localbits = this.bits;
            int thislength = localbits.length;
            long[] otherbits = o.bits;
            int otherlength = otherbits.length;
            if (thislength < otherlength) {
                this.expand(otherlength);
            }
            --otherlength;
            while (otherlength >= 0) {
                int n = otherlength;
                this.bits[n] = this.bits[n] | otherbits[otherlength];
                --otherlength;
            }
        }
    }

    @Override
    public boolean remove(Object e) {
        int pos;
        try {
            pos = this.cache.indexOf(e);
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (pos < 0) {
            return false;
        }
        long[] localbits = this.bits;
        if (BitExternalSet.bitvector_index(pos) >= localbits.length) {
            return false;
        }
        BitExternalSet.unset(localbits, pos);
        this.removeTrailingZeros();
        return true;
    }

    @Override
    public int size() {
        int count = 0;
        long[] localbits = this.bits;
        for (int pos = localbits.length - 1; pos >= 0; --pos) {
            long bitvector = localbits[pos];
            if (bitvector == 0L) continue;
            for (int i = 0; i < 64; ++i) {
                if (!BitExternalSet.isset(localbits, 64 * pos + i)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        this.removeTrailingZeros();
        return this.bits.length == 1 && this.bits[0] == 0L;
    }

    private void removeTrailingZeros() {
        int length;
        long[] localbits = this.bits;
        for (length = localbits.length; length > 1 && localbits[length - 1] == 0L; --length) {
        }
        if (length != localbits.length) {
            this.shrink(length);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new BitSetIterator();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cache == null ? 1 : this.cache.hashCode());
        result = 31 * result + Arrays.hashCode(this.bits);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BitExternalSet other = (BitExternalSet)obj;
        if (this.cache != other.cache) {
            other = (BitExternalSet)this.cache.mkSet(other);
        }
        return Arrays.equals(this.bits, other.bits);
    }

    public String toString() {
        return "[" + StringUtils.join((Iterable)this, (String)", ") + "]";
    }

    @Override
    public void clear() {
        this.bits = new long[1];
    }

    @Override
    public BitExternalSet<T> copy() {
        return new BitExternalSet<T>(this);
    }

    @Override
    public boolean contains(ExternalSet<T> other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.cache != other.getCache()) {
            return false;
        }
        if (!(other instanceof BitExternalSet)) {
            return ExternalSet.super.contains(other);
        }
        BitExternalSet o = (BitExternalSet)other;
        long[] otherbits = o.bits;
        long[] localbits = this.bits;
        if (otherbits.length > localbits.length) {
            return false;
        }
        for (int i = otherbits.length - 1; i >= 0; --i) {
            if ((localbits[i] | otherbits[i]) == localbits[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(ExternalSet<T> other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.cache != other.getCache()) {
            return false;
        }
        if (!(other instanceof BitExternalSet)) {
            return ExternalSet.super.intersects(other);
        }
        BitExternalSet o = (BitExternalSet)other;
        long[] otherbits = o.bits;
        long[] localbits = this.bits;
        int min = otherbits.length > localbits.length ? localbits.length : otherbits.length;
        for (int i = min - 1; i >= 0; --i) {
            if ((localbits[i] & otherbits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExternalSet<T> intersection(ExternalSet<T> other) {
        BitExternalSet<T> result;
        int index;
        long[] otherbits;
        if (this == other) {
            return this;
        }
        if (other == null) {
            return this;
        }
        if (this.cache != other.getCache()) {
            return this;
        }
        if (!(other instanceof BitExternalSet)) {
            return ExternalSet.super.intersection(other);
        }
        BitExternalSet o = (BitExternalSet)other;
        if (this.bits.length > o.bits.length) {
            otherbits = this.bits;
            index = o.bits.length;
            result = new BitExternalSet<T>(o);
        } else {
            otherbits = o.bits;
            index = this.bits.length;
            result = new BitExternalSet<T>(this);
        }
        long[] res = result.bits;
        while (index > 0) {
            int n = --index;
            res[n] = res[n] & otherbits[index];
        }
        result.removeTrailingZeros();
        return result;
    }

    @Override
    public ExternalSet<T> difference(ExternalSet<T> other) {
        if (this == other) {
            return this;
        }
        if (other == null) {
            return this;
        }
        if (this.cache != other.getCache()) {
            return this;
        }
        if (!(other instanceof BitExternalSet)) {
            return ExternalSet.super.difference(other);
        }
        BitExternalSet o = (BitExternalSet)other;
        long[] localbits = this.bits;
        int pos = localbits.length;
        BitExternalSet<T> result = new BitExternalSet<T>(this);
        long[] otherbits = o.bits;
        long[] res = result.bits;
        if (otherbits.length < pos) {
            pos = otherbits.length;
        }
        while (--pos >= 0) {
            int n = pos;
            res[n] = res[n] & (otherbits[pos] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        result.removeTrailingZeros();
        return result;
    }

    @Override
    public ExternalSet<T> union(ExternalSet<T> other) {
        BitExternalSet<T> result;
        if (this == other) {
            return this;
        }
        if (other == null) {
            return this;
        }
        if (this.cache != other.getCache()) {
            return this;
        }
        if (!(other instanceof BitExternalSet)) {
            return ExternalSet.super.union(other);
        }
        BitExternalSet o = (BitExternalSet)other;
        long[] localbits = this.bits;
        int thislength = localbits.length;
        long[] otherbits = o.bits;
        int otherlength = otherbits.length;
        if (thislength < otherlength) {
            result = new BitExternalSet<T>(o);
            long[] res = result.bits;
            --thislength;
            while (thislength >= 0) {
                int n = thislength;
                res[n] = res[n] | localbits[thislength];
                --thislength;
            }
        } else {
            result = new BitExternalSet<T>(this);
            long[] res = result.bits;
            while (--otherlength >= 0) {
                int n = otherlength;
                res[n] = res[n] | otherbits[otherlength];
            }
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        int pos;
        try {
            pos = this.cache.indexOf(o);
        }
        catch (ClassCastException e) {
            return false;
        }
        if (pos < 0) {
            return false;
        }
        int bitvector = BitExternalSet.bitvector_index(pos);
        return bitvector < this.bits.length && BitExternalSet.isset(this.bits, pos);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (T t : this) {
            array[i++] = t;
        }
        return array;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return new ArrayList(this).toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (T o : c) {
            result |= this.add(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<T> toRemove = new ArrayList<T>();
        for (Object o : this) {
            if (c.contains(o)) continue;
            toRemove.add(o);
        }
        for (Object o : toRemove) {
            this.remove(o);
        }
        return !toRemove.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ArrayList<T> toRemove = new ArrayList<T>();
        for (Object o : this) {
            if (!c.contains(o)) continue;
            toRemove.add(o);
        }
        for (Object o : toRemove) {
            this.remove(o);
        }
        return !toRemove.isEmpty();
    }

    static long bitmask(int n) {
        return 1L << n % 64;
    }

    static int bitvector_index(int n) {
        return n >> 6;
    }

    static void set(long[] bits, int n) {
        int n2 = BitExternalSet.bitvector_index(n);
        bits[n2] = bits[n2] | BitExternalSet.bitmask(n);
    }

    static void unset(long[] bits, int n) {
        int n2 = BitExternalSet.bitvector_index(n);
        bits[n2] = bits[n2] & (BitExternalSet.bitmask(n) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static boolean isset(long[] bits, int n) {
        return (bits[BitExternalSet.bitvector_index(n)] & BitExternalSet.bitmask(n)) != 0L;
    }

    private final class BitSetIterator
    implements Iterator<T> {
        private int next;
        private final long[] bits;
        private final int totalBits;

        private BitSetIterator() {
            this.bits = BitExternalSet.this.bits;
            this.totalBits = this.bits.length << 6;
            this.next = this.findNextBit();
        }

        private int findNextBit() {
            long[] localbits = this.bits;
            int l = this.totalBits;
            for (int start = this.next; start < l; ++start) {
                int pos = BitExternalSet.bitvector_index(start);
                long bitvector = localbits[pos];
                while (bitvector == 0L) {
                    if ((start += 64) >= l) {
                        return -1;
                    }
                    bitvector = localbits[++pos];
                }
                long bit = BitExternalSet.bitmask(start);
                do {
                    if ((bitvector & bit) != 0L) {
                        return start;
                    }
                } while ((bit <<= 1) != 0L);
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        @Override
        public T next() {
            if (this.next < 0) {
                throw new NoSuchElementException();
            }
            int nb = this.next++;
            this.next = this.findNextBit();
            return BitExternalSet.this.cache.get(nb);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal from a bitset is not supported");
        }
    }
}

