/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections.externalSet;

import it.unive.lisa.util.collections.externalSet.BitExternalSet;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import it.unive.lisa.util.collections.externalSet.UniversalExternalSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalSetCache<T> {
    private final List<T> elements = new ArrayList<T>(16);
    private final Map<T, Integer> indexes = new HashMap<T, Integer>(16);
    private int nextIndex = 0;
    private int indexOfNull = -1;

    public ExternalSet<T> mkEmptySet() {
        return new BitExternalSet(this);
    }

    public ExternalSet<T> mkSet(Iterable<T> iterable) {
        return new BitExternalSet<T>(this, iterable);
    }

    public ExternalSet<T> mkSingletonSet(T element) {
        return new BitExternalSet<T>(this, element);
    }

    public ExternalSet<T> mkUniversalSet() {
        return new UniversalExternalSet(this);
    }

    protected final synchronized int indexOf(T e) {
        if (e == null) {
            return this.indexOfNull;
        }
        Integer result = this.indexes.get(e);
        return result == null ? -1 : result;
    }

    protected final synchronized int indexOfOrAdd(T e) {
        if (e == null) {
            if (this.indexOfNull == -1) {
                this.elements.add(null);
                this.indexOfNull = this.nextIndex++;
            }
            return this.indexOfNull;
        }
        Integer result = this.indexes.get(e);
        if (result == null) {
            return this.indexes.computeIfAbsent(e, el -> {
                this.elements.add(e);
                return this.nextIndex++;
            });
        }
        return result;
    }

    protected final synchronized T get(int pos) {
        return this.elements.get(pos);
    }

    public final synchronized void clear() {
        this.elements.clear();
        this.indexes.clear();
        this.indexOfNull = -1;
        this.nextIndex = 0;
    }

    public final synchronized int size() {
        return this.elements.size();
    }

    public final synchronized String toString() {
        return this.elements.toString();
    }

    synchronized Collection<T> getAllElements() {
        return Collections.unmodifiableCollection(this.elements);
    }
}

