/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections.externalSet;

import it.unive.lisa.util.collections.externalSet.BitExternalSet;
import it.unive.lisa.util.collections.externalSet.ExternalSet;
import it.unive.lisa.util.collections.externalSet.ExternalSetCache;
import java.util.Collection;
import java.util.Iterator;

public class UniversalExternalSet<T>
implements ExternalSet<T> {
    private static final String CANNOT_PERFORM_ERROR = "Cannot remove elements from a universal view of an external set";
    private final ExternalSetCache<T> cache;

    UniversalExternalSet(ExternalSetCache<T> cache) {
        this.cache = cache;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        try {
            return this.cache.indexOf(o) != -1;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.cache.getAllElements().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.cache.getAllElements().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.cache.getAllElements().toArray(a);
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException(String.format(CANNOT_PERFORM_ERROR, "add"));
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(String.format(CANNOT_PERFORM_ERROR, "remove"));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.cache.getAllElements().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException(String.format(CANNOT_PERFORM_ERROR, "add"));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(String.format(CANNOT_PERFORM_ERROR, "remove"));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(String.format(CANNOT_PERFORM_ERROR, "remove"));
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(String.format(CANNOT_PERFORM_ERROR, "remove"));
    }

    @Override
    public ExternalSetCache<T> getCache() {
        return this.cache;
    }

    @Override
    public ExternalSet<T> copy() {
        return new BitExternalSet<T>(this.cache, this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cache == null ? 0 : this.cache.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniversalExternalSet other = (UniversalExternalSet)obj;
        return !(this.cache == null ? other.cache != null : !this.cache.equals(other.cache));
    }
}

