/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph.algorithms;

import it.unive.lisa.util.collections.workset.FIFOWorkingSet;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class Dominators<G extends Graph<G, N, E>, N extends Node<N, E, G>, E extends Edge<N, E, G>> {
    private final Map<N, Set<N>> dominators = new IdentityHashMap<N, Set<N>>();

    public Map<N, Set<N>> getDominators() {
        return this.dominators;
    }

    public Map<N, Set<N>> build(G graph) {
        this.dominators.clear();
        Collection entries = ((Graph)graph).getEntrypoints();
        FIFOWorkingSet ws = FIFOWorkingSet.mk();
        entries.forEach(ws::push);
        while (!ws.isEmpty()) {
            Node current = (Node)ws.pop();
            Set<Object> res = entries.contains(current) ? new HashSet<Node>() : this.intersect(((Graph)graph).predecessorsOf((Node)current));
            res.add(current);
            if (res.equals(this.dominators.get(current))) continue;
            this.dominators.put(current, res);
            ((Graph)graph).followersOf((Node)current).forEach(ws::push);
        }
        return this.dominators;
    }

    private Set<N> intersect(Collection<N> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Object> res = null;
        for (Node node : nodes) {
            Set<N> doms = this.dominators.get(node);
            if (doms != null) {
                if (res == null) {
                    res = new HashSet<N>(doms);
                } else {
                    res.retainAll(doms);
                }
            }
            if (res == null || !res.isEmpty()) continue;
            break;
        }
        return res == null ? new HashSet() : res;
    }
}

