/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph.algorithms;

import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.Node;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Fixpoint<G extends Graph<G, N, E>, N extends Node<N, E, G>, E extends Edge<N, E, G>, T> {
    private static final String ERROR = "Exception while %s of '%s' in '%s'";
    private final Graph<G, N, E> graph;
    private final Map<N, T> result;

    public Fixpoint(Graph<G, N, E> graph) {
        this.graph = graph;
        this.result = new HashMap<N, T>(graph.getNodesCount());
    }

    public Map<N, T> fixpoint(Map<N, T> startingPoints, WorkingSet<N> ws, FixpointImplementation<N, E, T> implementation) throws FixpointException {
        this.result.clear();
        startingPoints.keySet().forEach(ws::push);
        while (!ws.isEmpty()) {
            T newApprox;
            Node current = (Node)ws.pop();
            if (current == null) {
                throw new FixpointException("null node encountered during fixpoint in '" + this.graph + "'");
            }
            if (!this.graph.getAdjacencyMatrix().containsNode(current)) {
                throw new FixpointException("'" + current + "' is not part of '" + this.graph + "'");
            }
            T entrystate = this.getEntryState(current, startingPoints.get(current), implementation);
            if (entrystate == null) {
                throw new FixpointException("'" + current + "' does not have an entry state");
            }
            try {
                newApprox = implementation.semantics(current, entrystate);
            }
            catch (Exception e) {
                throw new FixpointException(String.format(ERROR, "computing semantics", current, this.graph), e);
            }
            T oldApprox = this.result.get(current);
            if (oldApprox != null) {
                try {
                    newApprox = implementation.join(current, newApprox, oldApprox);
                }
                catch (Exception e) {
                    throw new FixpointException(String.format(ERROR, "joining states", current, this.graph), e);
                }
            }
            try {
                if (oldApprox != null && implementation.equality(current, newApprox, oldApprox)) continue;
                this.result.put(current, newApprox);
                for (Node instr : this.graph.followersOf(current)) {
                    ws.push(instr);
                }
            }
            catch (Exception e) {
                throw new FixpointException(String.format(ERROR, "updating result", current, this.graph), e);
            }
        }
        return this.result;
    }

    private T getEntryState(N current, T startstate, FixpointImplementation<N, E, T> implementation) throws FixpointException {
        Collection<N> preds = this.graph.predecessorsOf(current);
        ArrayList<T> states = new ArrayList<T>(preds.size());
        for (Object pred : preds) {
            if (!this.result.containsKey(pred)) continue;
            E edge = this.graph.getEdgeConnecting(pred, current);
            try {
                states.add(implementation.traverse(edge, this.result.get(pred)));
            }
            catch (Exception e) {
                throw new FixpointException(String.format(ERROR, "computing edge semantics", edge, this.graph), e);
            }
        }
        Object entrystate = startstate;
        try {
            for (Object s : states) {
                if (entrystate == null) {
                    entrystate = s;
                    continue;
                }
                entrystate = implementation.union(current, entrystate, s);
            }
        }
        catch (Exception e) {
            throw new FixpointException(String.format(ERROR, "creating entry state", current, this.graph), e);
        }
        return entrystate;
    }

    public static interface FixpointImplementation<N, E, T> {
        public T semantics(N var1, T var2) throws Exception;

        public T traverse(E var1, T var2) throws Exception;

        public T union(N var1, T var2, T var3) throws Exception;

        public T join(N var1, T var2, T var3) throws Exception;

        public boolean equality(N var1, T var2, T var3) throws Exception;
    }
}

