/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;

public class FileManager {
    private final File workdir;
    private final Collection<String> createdFiles = new TreeSet<String>();

    public FileManager(String workdir) {
        this.workdir = Paths.get(workdir, new String[0]).toFile();
    }

    public Collection<String> createdFiles() {
        return this.createdFiles;
    }

    public void mkOutputFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(name, false, filler);
    }

    public void mkDotFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(FileManager.cleanupForDotFile(name) + ".dot", false, filler);
    }

    public void mkOutputFile(String name, boolean bom, WriteAction filler) throws IOException {
        File file = new File(this.workdir, name);
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory structure for " + file);
        }
        this.createdFiles.add(name);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8.newEncoder());){
            if (bom) {
                ((Writer)writer).write(65279);
            }
            filler.perform(writer);
        }
    }

    private static String cleanupForDotFile(String name) {
        String result = name.replace(' ', '_');
        result = result.replace("::", ".");
        return result;
    }

    public static void forceDeleteFolder(String path) throws IOException {
        File workdir = new File(path);
        if (workdir.exists()) {
            FileUtils.forceDelete((File)workdir);
        }
    }

    @FunctionalInterface
    public static interface WriteAction {
        public void perform(Writer var1) throws IOException;
    }
}

