/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.collection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import lombok.NonNull;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class SymmetricImmutablePair<Type extends Comparable<Type>>
implements Comparable<SymmetricImmutablePair<Type>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Type first;
    private final Type second;
    private final int hashCode;

    public SymmetricImmutablePair(@NonNull Type first, @NonNull Type second) {
        if (first == null) {
            throw new IllegalArgumentException("first is null");
        }
        if (second == null) {
            throw new IllegalArgumentException("second is null");
        }
        if (first.compareTo(second) < 0) {
            this.first = first;
            this.second = second;
        } else {
            this.first = second;
            this.second = first;
        }
        this.hashCode = new HashCodeBuilder(541, 7873).append(this.first).append(this.second).toHashCode();
    }

    @Override
    public int compareTo(SymmetricImmutablePair<Type> other) {
        int c = this.first.compareTo(other.first());
        if (0 == c) {
            return this.second.compareTo(other.second());
        }
        return c;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SymmetricImmutablePair)) {
            return false;
        }
        SymmetricImmutablePair other = (SymmetricImmutablePair)o;
        return 0 == this.compareTo(other);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @SuppressFBWarnings(justification="generated code")
    public Type first() {
        return this.first;
    }

    @SuppressFBWarnings(justification="generated code")
    public Type second() {
        return this.second;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "SymmetricImmutablePair(first=" + this.first() + ", second=" + this.second() + ", hashCode=" + this.hashCode() + ")";
    }
}

