/*
 * Decompiled with CFR 0.152.
 */
package com.github.liblevenshtein.collection.dictionary;

import com.github.liblevenshtein.collection.dictionary.DawgIterator;
import com.github.liblevenshtein.collection.dictionary.DawgNode;
import com.github.liblevenshtein.collection.dictionary.IFinalFunction;
import com.github.liblevenshtein.collection.dictionary.ITransitionFunction;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unimi.dsi.fastutil.chars.CharIterator;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dawg
extends AbstractSet<String>
implements IFinalFunction<DawgNode>,
ITransitionFunction<DawgNode>,
Serializable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(Dawg.class);
    private static final long serialVersionUID = 1L;
    protected DawgNode root = null;
    protected int size = 0;

    protected Dawg(DawgNode root, int size) {
        this.root = root;
        this.size = size;
    }

    public Dawg() {
        this(new DawgNode(), 0);
    }

    @Override
    public boolean at(DawgNode node) {
        return node.isFinal();
    }

    @Override
    public DawgNode of(DawgNode node, char label) {
        return node.transition(label);
    }

    @Override
    public CharIterator of(DawgNode node) {
        return node.labels();
    }

    @Override
    public abstract boolean add(String var1);

    @Override
    public synchronized boolean addAll(Collection<? extends String> terms) {
        int counter = 0;
        for (String string : terms) {
            if (!this.add(string)) {
                return false;
            }
            if (++counter % 10000 != 0) continue;
            log.info("Added [{}] of [{}] terms", (Object)counter, (Object)terms.size());
        }
        return true;
    }

    @Override
    public abstract boolean remove(Object var1);

    @Override
    public boolean contains(Object o) {
        char label;
        if (!(o instanceof String)) {
            return false;
        }
        String term = (String)o;
        DawgNode node = this.root;
        for (int i = 0; i < term.length() && null != node; node = node.transition(label), ++i) {
            label = term.charAt(i);
        }
        return null != node && node.isFinal();
    }

    @Override
    public Iterator<String> iterator() {
        return new DawgIterator(this.root, this);
    }

    public boolean replace(String current, String replacement) {
        throw new UnsupportedOperationException("replace is not supported");
    }

    public boolean replaceAll(Collection<? extends Map.Entry<String, String>> c) {
        throw new UnsupportedOperationException("replaceAll is not supported");
    }

    @Override
    public String toString() {
        return String.format("%s(size=%d)", this.getClass().getSimpleName(), this.size);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dawg)) {
            return false;
        }
        Dawg other = (Dawg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DawgNode this$root = this.root();
        DawgNode other$root = other.root();
        if (this$root == null ? other$root != null : !((Object)this$root).equals(other$root)) {
            return false;
        }
        return this.size() == other.size();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof Dawg;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DawgNode $root = this.root();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        result = result * 59 + this.size();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public DawgNode root() {
        return this.root;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int size() {
        return this.size;
    }
}

